/* 
 *   Copyright (C) 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model;

import javax.mail.search.SearchTerm;
import org.apache.log4j.Logger;


/**
 * Part of the client model.
 * Contains information about the result of a search
 */
public class SearchMessagesResult
{
    private final Logger log = Logger.getLogger(SearchMessagesResult.class);
    private SearchTerm criteria;
    private int folderIndex;
    private String folderName;
    private int[] matches;

    public SearchMessagesResult(SearchTerm criteria, int folderIndex, String folderName, int[] matches) {
	this.criteria = criteria;
	this.folderIndex = folderIndex;
	this.folderName = folderName;
	this.matches = matches;
    }

    public SearchTerm getCriteria() {
	return criteria;
    }

    public int getFolderIndex() {
	return folderIndex;
    }

    public String getFolderName() {
	return folderName;
    }

    public int[] getMatches() {
	return matches;
    }

    /** for debugging */
    public String toString() {
	StringBuffer ret = new StringBuffer();
	ret.append("SearchMessagesResult: ")
	    .append("criteria=").append(criteria)
	    .append(",matched folder=").append(folderName).append("(").append(folderIndex).append(") ")
	    .append(",nb messages=").append(matches.length);
	return ret.toString();
    }
}

