/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model;

import javax.mail.internet.InternetAddress;
import org.apache.log4j.Logger;

/**
 * Part of the client model encapsulating message composition data
 */
public class ComposeInfo
{
    private final Logger log = Logger.getLogger(ComposeInfo.class);

    private InternetAddress from;
    private String to;
    private String cc;
    private String replyTo;
    private String bcc;
    private String subject;
    private String body;
    private AttachmentHolder attachmentHolder;
    private ComposeReference reference;

    /**
     * @param reference : use this if the composition refers to an existing message.
     * Otherwise, set to null
     */
    public ComposeInfo(ComposeReference reference, long maxAttachmentSize, InternetAddress from) 
	throws IllegalArgumentException
    {
	log.debug("ComposeInfo() called");
	
	this.reference = reference;
	attachmentHolder = new AttachmentHolder(maxAttachmentSize);
	this.from = from;
    }
    
    public ComposeReference getReference() {
	return reference;
    }

    public InternetAddress getFrom() { return from;}
    public void setFrom(InternetAddress from) { this.from = from;}

    public String getTo() { return to;}
    public void setTo(String to) { this.to = to;}

    public String getCc() { return cc;}
    public void setCc(String cc) { this.cc = cc;}

    public String getReplyTo() { return replyTo;}
    public void setReplyTo(String replyTo) { this.replyTo = replyTo;}

    public String getBcc() { return bcc;}
    public void setBcc(String bcc) { this.bcc = bcc;}

    public String getSubject() { return subject;}
    public void setSubject(String subject) { this.subject = subject;}

    public String getBody() { 
	// only temporary logging, for tracing formatting problem of body
// 	if (log.isDebugEnabled())
// 	    log.debug("getBody() called, returning body " + body);

	return body;
    }
    public void setBody(String body) { this.body = body;}

    public AttachmentHolder getAttachmentHolder() { return attachmentHolder;}
    public void setAttachmentHolder(AttachmentHolder attachmentHolder) { this.attachmentHolder = attachmentHolder;}

    /**
     * must be called by creator to ensure clean up 
     */
    public void destroy() {
	attachmentHolder.destroy();
    }
}




