/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model;

import net.jatec.ironmailer.framework.StringTools;

/**
 * 
 */
public class AttachmentSizeExceededException extends ModelException
{
    private String allowedSize;
    private String currentSize;
    private String attachmentSize;
    private String attachmentName;

    public AttachmentSizeExceededException(long allowedSize, long currentSize, long attachmentSize, String attachmentName) 
    {
	super("adding attachment " + attachmentName + " of size " + attachmentSize + " to already attached stuff of size " + currentSize + " would exceed the maximum allowed size " + allowedSize);
	this.allowedSize = StringTools.sizeToString(allowedSize);
	this.currentSize = StringTools.sizeToString(currentSize);
	this.attachmentSize = StringTools.sizeToString(attachmentSize);
	this.attachmentName = attachmentName;
    }

    public String getAllowedSize() { return allowedSize; }
    
    public String getCurrentSize() { return currentSize; }

    public String getAttachmentSize() { return attachmentSize; }

    public String getAttachmentName() { return attachmentName; }
}
