/* 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.model;

import java.net.URL;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.log4j.Logger;

import net.jatec.ironmailer.framework.NetTools;

public class ApplicationConfiguration
{
    private final Logger log = Logger.getLogger(ApplicationConfiguration.class);
    private final static long DEFAULT_MAX_ATTACHMENT_SIZE = 10000;
    private final static String DEFAULT_ENCODING = "ISO-8859-1";
    private final static String DEFAULT_USER_CONFIGURATION_FOLDER = "WEBMAILCONF";
    private final static String DEFAULT_USER_CONTACTS_FOLDER = "WEBMAIL_CONTACTS";
    private final static String DEFAULT_DEMO_USER = "maildemo";
    private final static String DEFAULT_ADMIN = "root@localhost";

    private URL contextURL;
    private String host;
    private String hostProtocol;
    private long maxAttachmentSize;
    private String encoding;
    private String userConfigurationFolder;
    private String userContactsFolder;
    private String demoUser;
    private String admin;

    /**
     * @param par the parameters. There should be the following parameters:
     * application.maxAttachmentSize, application.encoding, application.userConfigurationFolder
     */
    public ApplicationConfiguration(URL contextURL, Parameters par) 
    {
        this.contextURL = contextURL;
	hostProtocol = contextURL.getProtocol();

	maxAttachmentSize = readParameter("maxAttachmentSize", par, "application.maxAttachmentSize", DEFAULT_MAX_ATTACHMENT_SIZE);

	encoding = readParameter("encoding",par,"application.encoding",DEFAULT_ENCODING);

	userConfigurationFolder = readParameter("userConfigurationFolder",par,"application.userConfigurationFolder",DEFAULT_USER_CONFIGURATION_FOLDER);

	userContactsFolder = readParameter("userContactsFolder",par,"application.userContactsFolder",DEFAULT_USER_CONTACTS_FOLDER);

	demoUser = readParameter("demoUser",par,"application.demoUser",DEFAULT_DEMO_USER);

	admin = readParameter("admin",par,"application.admin",DEFAULT_ADMIN);

	String stripPrefixFromHost = 
	    readParameter("stripPrefixFromHost",par,"application.stripPrefixFromHost",null);
	host = NetTools.getHost(contextURL, stripPrefixFromHost);

    }

    /** 
	for value of type long 
	TO DO : put this in framework ?
    */
    private long readParameter(String attributeName, 
			       Parameters par, String parameterName, 
			       long defaultValue) 
    {
	long ret;
	try {
	    ret = par.getParameterAsLong(parameterName);
	    if (log.isDebugEnabled())
		log.debug("readParameter() "
			  + attributeName  
			  + "=" + ret
		    );
	} catch (ParameterException e) {
	    log.warn("missing parameter, will use default: " + e.toString());
	    ret = defaultValue;
	}
	return ret;
    }

    private boolean readParameter(String attributeName, 
				  Parameters par, String parameterName, 
				  boolean defaultValue) 
    {
	boolean ret;
	try {
	    ret = par.getParameterAsBoolean(parameterName);
	    if (log.isDebugEnabled())
		log.debug("readParameter() "
			  + attributeName  
			  + "=" + ret
		    );
	} catch (ParameterException e) {
	    log.warn("missing parameter, will use default: " + e.toString());
	    ret = defaultValue;
	}
	return ret;
    }

    private String readParameter(String attributeName, 
				 Parameters par, String parameterName, 
				 String defaultValue) 
    {
	String ret;
	try {
	    ret = par.getParameter(parameterName);
	    if (log.isDebugEnabled())
		log.debug("readParameter() "
			  + attributeName  
			  + "=" + ret
		    );
	} catch (ParameterException e) {
	    log.warn("missing parameter, will use default: " + e.toString());
	    ret = defaultValue;
	}
	return ret;
    }

    public long getMaxAttachmentSize() {
	return maxAttachmentSize;
    }

    public String getEncoding() {
	return encoding;
    }

    public String getUserConfigurationFolder() {
	return userConfigurationFolder;
    }

    public String getUserContactsFolder() {
	return userContactsFolder;
    }

    public String getDemoUser() {
	return demoUser;
    }

    public String getAdmin() {
	return admin;
    }

    public String getHost() {
	return host;
    }

    public String getHostProtocol() {
	return hostProtocol;
    }

}
