/* 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.framework.xml;

import java.beans.ExceptionListener;
import java.beans.PersistenceDelegate;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.OutputStream;

import org.apache.log4j.Logger;
import net.jatec.ironmailer.framework.FrameworkException;
import net.jatec.ironmailer.framework.beans.NonGraphicCollectionPersistenceDelegate;
import net.jatec.ironmailer.framework.beans.NonGraphicPersistenceDelegate;


public class XMLWriter implements ExceptionListener
{
    private final static Logger log = Logger.getLogger(XMLWriter.class);

    private boolean conversionOK = true;
    private Exception conversionException = null;
    
    /**
     * This constructor relies on the default Java-Beans mechanisms for
     * writing an object into an XML stream. Note that this will only
     * work in an environment where a windowing system is available,
     * because of the implementation in the JDK (up to 1.4.1).
     * If this is not satisfactory, use the other constructor.
     */ 
    public XMLWriter(OutputStream os, Object o) 
	throws FrameworkException
    {
	this(os, o, null);
    }

    /**
     * @param types: all types to be serialized, i.e. where the default
     * Java serialization mechanism is not suitable due to the awt issues.
     * This means all user-defined subclasses within the object itself
     * you are trying to serialize.
     */ 
    public XMLWriter(OutputStream os, Object o, Class[] types) 
	throws FrameworkException
    {
	long start = 0;
	long end = 0;

	if (log.isDebugEnabled()) {
	    log.debug("XMLWriter() called");
	    start = System.currentTimeMillis();
	}

	XMLEncoder e = new XMLEncoder(new BufferedOutputStream(os));
	e.setExceptionListener(this);
	if (types != null) {
	    log.debug("XMLWriter() setting custom persistence delegate");
	    PersistenceDelegate myDel = new NonGraphicPersistenceDelegate();
	    PersistenceDelegate myCollectionDel = new NonGraphicCollectionPersistenceDelegate();
	    for (int i = 0; i < types.length; i++) {
		Class type = types[i];
		if (java.util.AbstractCollection.class.isAssignableFrom(type))
		    e.setPersistenceDelegate(type, myCollectionDel);
		else
		    e.setPersistenceDelegate(type, myDel);

	    }
	    // add other stuff that somehow seems to use the default-crap thing if it occurs :(
	    e.setPersistenceDelegate(Object.class, myDel);
	    e.setPersistenceDelegate(Number.class, myDel);

	}
	e.writeObject(o);
	e.close();
	
	if (! conversionOK)
	    throw new FrameworkException("error in XMLWriter", conversionException);

	if (log.isDebugEnabled()) {
	    end = System.currentTimeMillis() - start;
	    log.debug("XMLWriter() successfully completed in (ms) " + end);
	}
    }

    public void exceptionThrown(Exception e) {
	conversionOK = false;
	conversionException = e;
    }
}


