/* 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.framework.xml;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.io.InputStream;
import java.io.BufferedInputStream;

import net.jatec.ironmailer.framework.FrameworkException;

public class XMLReader implements ExceptionListener
{
    private boolean conversionOK = true;
    private Exception conversionException = null;
    
    public XMLReader()
    {
    }

    public Object getObject(InputStream input)
	throws FrameworkException
    {
	XMLDecoder d = new XMLDecoder(new BufferedInputStream(input));
	Object result = d.readObject();
	d.close();
	if (! conversionOK)
	    throw new FrameworkException("error in getObject", conversionException);      
	return result;
    }
    
    public void exceptionThrown(Exception e) {
	conversionOK = false;
	conversionException = e;
    }
}
