/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.framework;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.net.URL;
import org.apache.log4j.Logger;

public class NetTools
{
    public static final Logger log = Logger.getLogger(NetTools.class);
    private final static String DEFAULT_HOST = "localhost";

    /**
     * Try to determine host for the users context.
     * First, we look what host is set in the URL under which the user
     * is connected: this is useful for example for virtual hosts.
     * If the host is not set, try to determine to host name of local host
     * from class InetAddres
     * @param stripPrefixFromHost : if set, this prefix will be stripped
     * from the host
     */
    public static String getHost(URL contextURL, String stripPrefixFromHost) 
    {
	String host = contextURL.getHost();
	String retHost;
	// if default host is used, try to ascertain real host
	if (host.equals(DEFAULT_HOST)) 
	    try {
		retHost = InetAddress.getLocalHost().getCanonicalHostName();
		log.debug("getHost() determined real host to be " + retHost);
	    }
	    catch (UnknownHostException e) {
		log.warn("getHost() got an unexpected error resolving host, reverting to default", e);
		retHost = host;
	    }
	else {
	    retHost = host;
	    if (stripPrefixFromHost != null 
		&& ! stripPrefixFromHost.equals("")) {
		if (log.isDebugEnabled())
		    log.debug("getHost() trying to strip from host name " + retHost + " this prefix: " + stripPrefixFromHost);
		if (retHost.startsWith(stripPrefixFromHost))
		    retHost = retHost.substring(stripPrefixFromHost.length());
	    }
	}
	if (log.isDebugEnabled())
	    log.debug("getRealHost() returning host name " + retHost);
	return retHost;
    }

}
