/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.framework;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;

public class HttpSessionManager
{
    private static HttpSessionManager instance = null;
    private static final String LOGON_MARKER = "HttpSessionManager.userName";
    
    /**
     * this class uses singleton pattern
     */
    protected HttpSessionManager() {
    }

    public static HttpSessionManager getInstance() {
        if (instance == null)
            instance = new HttpSessionManager();
        return instance;
    } 

 
    /**
     * Given an http request, determines if the requests lives in a valid
     * session, meaning the user has been identified.
     */
    public boolean isInValidSession(HttpServletRequest req) {
        HttpSession s = req.getSession(false);
        if (s != null) {
	    Object login = null;
	    try {
		login = s.getAttribute(LOGON_MARKER);
	    } catch (IllegalStateException ignored) {
	    }
	    return login != null;
	}
        else
            return false;
    }

    
    /**
     * Sets a marker in the session, containing the username, and indicating
     * that the session is active.
     *
     * @param s  a session (as obtained from the servlet container)
     * @param username the user which was successfully identified
     * @exception IllegalStateException  if this method is called on an invalidated session
     * @see #isSessionValid(HttpSession)
     * @see #getUserName(HttpSession)
     */
    public void setLoginDone(HttpSession s, String username) throws IllegalStateException {
        s.setAttribute(LOGON_MARKER, username);
    }


    /**
     * Mark a session as invalid (for instance, when the user has logged out).
     *
     * @param req the request
     */
    public void invalidateSession(HttpServletRequest req) {
        if (req != null) {
            HttpSession s = req.getSession(false);
            if (s != null) {
                try {
                    s.invalidate();
                } catch (IllegalStateException ignored) {
                }
            }
        }
    }


}

