/* 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller.action;

import java.util.Map;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletRequest;
import org.apache.cocoon.environment.Redirector;
import org.apache.log4j.Logger;

import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.MailWorkerBean;
import net.jatec.ironmailer.framework.MailTools;
import net.jatec.ironmailer.framework.ServletTools;
import net.jatec.ironmailer.model.ComposeReference;
import net.jatec.ironmailer.model.ComposeInfo;
import net.jatec.ironmailer.model.Contact;
import net.jatec.ironmailer.model.user.UserPreferences;

class ComposeAction implements ActionDispatcher.ActionStrategy
{
    private final Logger log = Logger.getLogger(ComposeAction.class);

    public void process(ServletRequest req, MailWorkerBean wb, Redirector redirector, Map objectModel)
	throws ControllerException
    {
	// if continue flag is set, nothing needs to be done
	// otherwise, new composition
	boolean isContinue = ServletTools.getBoolean(req, "continue");

	if (isContinue) {
	    log.debug("process() requested to continue - not resetting worker bean");
	}
	else {
	    // First, check if "to" field is to be pre-set
	    int[] contactIndices = null;
	    if (req.getParameter("selectaddr") != null) {
		if (log.isDebugEnabled())
		    log.debug("process() handling case where addresses where selected for composition");
		contactIndices = ServletTools.getSelectedIndices(req, "checkeditem");
		if (contactIndices != null) {
		    if (log.isDebugEnabled())
			log.debug("process() got selectedIndices");
		}
	    }
	    else {
		if (log.isDebugEnabled())
		    log.debug("process() no group of initial addresses, checking for single initial address");
		String s_initialTo = ServletTools.getString(req,"toContact");
		if (s_initialTo != null) {
		    if (log.isDebugEnabled())
			log.debug("process() got single initial address");
		    int cIndex = (new Integer(s_initialTo)).intValue();
		    contactIndices = new int[1];
		    contactIndices[0] = cIndex;
		}
	    }

	    
	    boolean isReply = ServletTools.getBoolean(req,"isreply");
	    boolean isForward = ServletTools.getBoolean(req,"isforward");
	    int folderNr = -1;
	    int messageNr = -1;
	    ComposeReference reference = null;

	    if (isReply || isForward) {
		// get referenced message
		folderNr = ServletTools.getInteger(req,"folderNr",true);
		messageNr = ServletTools.getInteger(req,"messageNr",true);
		log.debug("process() detected reply/forward, for message " + messageNr + " in folder " + folderNr + ", isReply? " + isReply);

		// ok, got message reference. Now get any additional settings
		boolean isReplyAll = ServletTools.getBoolean(req,"to_all");
		boolean isForwardAsAttachment = ServletTools.getBoolean(req, "forward_as_attachment");
					  
		reference = new ComposeReference(isReply, isForward, wb.getMailMessage(folderNr, messageNr), folderNr, messageNr, isReplyAll, isForwardAsAttachment);
	    }
	    else {
		// new composition
		log.debug("process() will not reference an existing message");
		reference = null;
	    }

	    // determine user from address, according to current preference settings
	    UserPreferences up = wb.getUserPreferences();
	    InternetAddress fromAddress = up != null ? up.getFromAddress() : null;
	    if (fromAddress == null) {
		fromAddress = wb.getMailSender().getDefaultFromUser();
		log.debug("process() using default from address: " + fromAddress.toString());
	    }
	    else {
		log.debug("process() using user configured from address: " + fromAddress.toString());
	    }

	    ComposeInfo ci = new ComposeInfo(reference, 
					     wb.getApplicationConfiguration().getMaxAttachmentSize(),
					     fromAddress);
	    if (contactIndices != null) 
		ci.setTo(wb.getContactListController().getContactList().getContactEmails(contactIndices));
	    
	    wb.setComposeInfo(ci);
	}
    }
}
