/* 
 *   Copyright (C) 2002, 2003 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package net.jatec.ironmailer.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpEnvironment;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

import net.jatec.ironmailer.framework.HttpSessionManager;
import net.jatec.ironmailer.model.MailPart;

public class AttachmentReader extends AbstractReader
{
    private final Logger log = Logger.getLogger(AttachmentReader.class);

    private MailWorkerBean wb;
    private MailPart ma;

    /**
     * overwrite setup() to get a handle on the worker bean
     */
    public void setup(SourceResolver resolver, Map objectModel, 
		      String src, Parameters par)
        throws ProcessingException, SAXException, IOException 
    {
        super.setup(resolver, objectModel, src, par);
	log.debug("setup() called");

	HttpServletRequest req =(HttpServletRequest)
	    objectModel.get(HttpEnvironment.HTTP_REQUEST_OBJECT);	

	if (log.isDebugEnabled()) {
	    log.debug("setup() req.getContextPath()=" + req.getContextPath());
	    log.debug("setup() req.getPathInfo()=" + req.getPathInfo());
	    log.debug("setup() req.getPathTranslated()=" + req.getPathTranslated());
	    log.debug("setup() req.getQueryString()=" + req.getQueryString());
	    log.debug("setup() req.getRequestURI()=" + req.getRequestURI());
	    log.debug("setup() req.getServletPath()=" + req.getServletPath());
	}

	String folderNr = null;
	String messageNr = null;
	String attachmentNr = null;
	String partNr = null;

	try {
	    // 1. Check that a session exists. If not, setup fails
	    if (! HttpSessionManager.getInstance().isInValidSession(req))
		throw new Exception("setup error: not living in session");

	    // 2. Get worker bean (insure there is one in the session)
	    HttpSession session = (HttpSession)req.getSession(false);
	    wb = (MailWorkerBean)session.getAttribute("workerBean");
	    if (wb == null)
		throw new Exception("setup error: in a valid session but no worker bean found");

	    // 3. Check parameters
	    folderNr = (String)req.getParameter("folderNr");
	    if (folderNr == null) throw new Exception("missing parameter folderNr");
	    folderNr = folderNr.trim();
	    messageNr = (String)req.getParameter("messageNr");
	    if (messageNr == null) throw new Exception("missing parameter messageNr");
	    messageNr = messageNr.trim();
	    attachmentNr = (String)req.getParameter("attachmentNr");
	    if (attachmentNr == null) throw new Exception("missing parameter attachmentNr");
	    attachmentNr = attachmentNr.trim();
	    // optional parameters
	    partNr = (String)req.getParameter("partNr");

	    if (partNr == null)
		ma = wb.getMailAttachment(Integer.parseInt(folderNr),Integer.parseInt(messageNr),Integer.parseInt(attachmentNr));
	    else {
		partNr = partNr.trim();
		ma = wb.getMailAttachmentPart(Integer.parseInt(folderNr),Integer.parseInt(messageNr),Integer.parseInt(attachmentNr),Integer.parseInt(partNr));
	    }
	}
	catch (Throwable t) {
	    log.error("setup() got some unexpected error, probably due to a setup error", t);
	    throw new ProcessingException("setup() got some unexpected error, probably due to a setup error: " + t.toString());
	}

	log.debug("setup() read parameters folderNr=" + folderNr + ", messageNr=" + messageNr + ", attachmentNr=" + attachmentNr);
    }

    public String getMimeType() {
	log.debug("getMimeType() called");
	String ret = (ma != null ? ma.getContentType() : null);
	log.debug("getMimeType() returning value " + ret);
	return ret;
    }

    public long getLastModified() {
	return 0;
    }

    public void generate()
	throws java.io.IOException,
	       org.xml.sax.SAXException,
	       ProcessingException
    {
	log.debug("generate() called");

	// write to output
        try {
	    if (ma == null)
		throw new Exception("internal error: ma (pointer to mail attachment) is null");

	    if (ma.isText()) {
		// write text into output stream
		log.debug("generate(): writing string into output stream");
		// TO DO : check if we need to provide encoding
		Writer outwriter = new BufferedWriter(new OutputStreamWriter(out));
		outwriter.write(ma.getText());
		outwriter.flush();
	    } 
	    else {
		log.debug("generate(): reading attachment as stream and writing into output");
		InputStream inputStream = ma.getInputStream();
		if (inputStream == null)
		    throw new Exception("internal error: input stream from mail attachment is null");

		byte[] buffer = new byte[8192];
		int length = -1;
		while ((length = inputStream.read(buffer)) > -1) {
		    out.write(buffer, 0, length);
		}
		inputStream.close();
		inputStream = null;
		out.flush();
	    }
	}
	catch (IOException ioe) {
            log.debug("generate() received an IOException, assuming client severed connection on purpose");
        }
	catch (Exception e) {
	    log.error("generate() unexpected error", e);
	    throw new ProcessingException("generate() got some unexpected error: " + e.toString());
	}
	log.debug("generate successful.");
    }

    public static void logParameters(Logger log, Parameters parameters) {
	if (parameters == null)
	    log.debug("null parameters");
	else {
	    String[] parNames = parameters.getNames();
	    log.debug("parameters has " + parNames.length + " items");
	    try {
		for (int i = 0; i < parNames.length; i++) {
		    String thisPar = parNames[i];
		    log.debug("parameter " + thisPar + "=" + parameters.getParameter(thisPar));
		}
	    }
	    catch (ParameterException e) {
		log.error("unable to read parameters", e);
	    }
	}

    }
}


