/*
* Test ipv6
* written by ale in milano on 13 sep 2008

Copyright (C) 2023 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/
#if !defined PIC_H_INCLUDED
#include <db.h>

#define IP_PER_DOT (16)
#define PIC_WIDTH (1600)
#define PIC_HEIGHT (86400*21/(1200)) /* 21 days at 20 mins */

typedef struct day_stats
{
	int caught, blocked, infected, fixed, ranges, widest, singletons;
} day_stats;

typedef struct pic_params
{
	double initial_decay;
	int initial_count;
	int attacks_per_minute, seed, minutes_per_pixel;
	int pic_height;
} pic_params;

struct pic_handle;
typedef struct pic_handle pic_handle;

pic_handle *pic_open(pic_params *pp, day_stats* stats);
int pic_draw_line(pic_handle *pic, time_t now, DB* db, int is_halfway);
void pic_set_caught(pic_handle *pic, unsigned char const ip[16]);
void pic_done(pic_handle *pic);

#define PIC_H_INCLUDED
#endif //!defined PIC_H_INCLUDED
