/*
* logline_written_block.h

Copyright (C) 2019-2021 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/

#if !defined LOGLINE_WRITTEN_BLOCK_H_INCLUDED

/*
This function references report_error() and ap.
Must be included after those definitions.

This is the line logging for ibd-parse -v and ibd-ban -l.
*/

static void logline_written_block(ip_u *ip_addr, void *key_data,
	int reason_id, int write_block_force,
	ip_data_t *ip_data, ip_data_t *old_data, DB *db1)
{
	char addr[INET6_ADDRSTRLEN];

	char descr[IPQBDB_DESCR_MAX_LENGTH + 5];
	get_descr(db1, reason_id,
		(write_block_force & write_block_force_add_category)?
			get_descr_add_category: 0,
		descr, sizeof descr);

	char const *what;
	if (old_data)
	{
		if (ip_addr->ip == 6 && key_data &&
			memcmp(ip_addr->u.ipv6, key_data, sizeof ip_addr->u.ipv6))
				what = "merged";
		else
			what = "old";
	}
	else
		what = "new";

	report_error(&ap, LOG_INFO,
		"%s record for %s, decay: %g, prob: %.2f%%, %s\n",
		what,
		my_inet_ntop(ip_addr, addr),
		ip_data->decay,
		percent_prob(ip_data->probability),
		descr);
}


#define LOGLINE_WRITTEN_BLOCK_H_INCLUDED
#endif
