/*
* ext_exec.h

Copyright (C) 2011 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/

#if !defined EXT_EXEC_H_INCLUDED

#include "dbstruct.h"

typedef struct connkill_cmd
{
	size_t ip_ndx;  // the replaced argument
	size_t argc;    // total number of arguments (excluding term. NULL)
	char *argv[];   // arguments, including command
} connkill_cmd;

connkill_cmd* read_connkill_cmd(app_private *ap);
void run_exec(connkill_cmd *cmd, char *ip, app_private *ap);

#define EXT_EXEC_H_INCLUDED
#endif
