/*
* dbstruct.h


Copyright (C) 2008 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef DBSTRUCT_H_INCLUDED
#define DBSTRUCT_H_INCLUDED

#include <sys/time.h>
#include <time.h>
#include <stdlib.h>
#include <db.h>

/*
* This is the data part of the main database
* (the key part is the IPv4 address)
*/
typedef struct ip_data_t
{
	double decay;       // >= IPQBDB_NEVER_DECAY for always blocked
	time_t last_update, last_block, created;
	int probability;    // 0-RAND_MAX probability of being blocked
	int reason_id;      // index into the reason file
	int block_cnt;      // number of packets blocked
	int decay_add_cnt;  // number of threshold upward passes
} ip_data_t;


/*
* This is the data part of the whitelist
* (the key part is the IPv4 address)
*/
typedef struct ip_white_t
{
	double decay;	// 0 = never block this ip, otherwise set initial decay
} ip_white_t;


/*
* This is the private data available via DB_ENV app_private
*/
typedef struct app_private
{
	int mode; // report_error
	char const *err_prefix;
} app_private;

enum error_report_mode {error_report_stderr}; // or syslog facility

#if defined __GNUC__
__attribute__ ((format(printf, 3, 4)))
#endif
void report_error(app_private* ap, int priority, char const *fmt, ...);

void fputs_database_help(void);
char *database_fname(char const *name, app_private*);
int open_database(char *name, app_private *ap, DB_ENV**, DB**);
int close_db(DB *db);
int close_dbenv(DB_ENV *db_env, int cleanup);


enum
{ get_descr_quoted = 1, get_descr_add_id = 2 };
int get_descr(DB *db, int id, int opt, char *dest, size_t size);
int last_descr_ndx(DB *db1);
int get_reason_id(int *reason_id, char *reason_string,
	app_private *ap, DB *db1, DB *db2, int verbose);
int open_descrdb(char *fname, DB_ENV *db_env, DB** db1, DB** db2);
int check_whitelist(DB *, uint32_t ip, double *decay);
typedef void (*write_block_cb)(uint32_t ip_addr,
	ip_data_t *ip_data, ip_data_t *old_data, DB *db_d);
enum
{ write_block_force_decay = 1, write_block_force_probability = 2,
	write_block_force_reason = 4};
int write_block(DB *db, uint32_t ip_addr, double decay, int reason_id,
	int initial_probability, int force, write_block_cb verbose_fn, DB *db_d);


void fputs_initial_count_help(void);

int caught_signal; // defined in the main module, tested while opening db
#endif // DBSTRUCT_H_INCLUDED
