/*
* config_names.h


Copyright (C) 2008 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/
#ifndef CONFIG_NAMES_H_INCLUDED
#define CONFIG_NAMES_H_INCLUDED

#if defined HAVE_CONFIG
#include <config.h>
#else
#define PACKAGE_VERSION "unknown"
#endif

/*
* These are "reasonable" configuration values that can be overridden
* at compile time.
*/

// The database prefix will be used unless the name supplied starts with '/'.
// The prefix should contain the full path to a directory, and optionally
// a basename prefix.
#if !defined IPQBDB_DATABASE_PREFIX
#define IPQBDB_DATABASE_PREFIX "/var/lib/ipqbdb/"
//#define IPQBDB_DATABASE_PREFIX "/home/ale/tmp/ipqbdbd/"
#endif

// The database suffix will be used unless the name supplied already ends
// with that string
#if !defined IPQBDB_DATABASE_SUFFIX
#define IPQBDB_DATABASE_SUFFIX ".db"
#endif

// The default database name
#if !defined IPQBDB_DATABASE_NAME
#define IPQBDB_DATABASE_NAME "block"
#endif

// The default whitelist database name
#if !defined IPQBDB_WHITE_DATABASE_NAME
#define IPQBDB_WHITE_DATABASE_NAME "white"
#endif

// The default reason description strings table database name
#if !defined IPQBDB_DESCR_DATABASE_NAME
#define IPQBDB_DESCR_DATABASE_NAME "descr"
#endif

// The max length (including terminating 0) of a description
// Descriptions are stored in a table as variable length records;
// however, the buffer used to retrieve them has this length.
#if !defined IPQBDB_DESCR_MAX_LENGTH
#define IPQBDB_DESCR_MAX_LENGTH 256
#endif

// The option aliases file, there is no other configuration except PCRE
// (However, the DB_HOME environment variable may be set to a directory
// containing a DB_CONFIG file that will be read on automatic environment
// creation. See Sleepycat docs, in particular for set_cachesize.)
#if !defined IPQBDB_OPTION_FILE
#define IPQBDB_OPTION_FILE "/etc/ipqbdb.popt"
#endif

// The PCRE expressions for parsing by ibd-parse
#if !defined IPQBDB_PCRE_FILE
#define IPQBDB_PCRE_FILE "/etc/ipqbdb-pcre.conf"
#endif

// The socket where ibd-parse listens
#if !defined IPQBDB_PARSE_SOCKET
#define IPQBDB_PARSE_SOCKET "ibd-parse.sock"
#endif

/*
* These values rule overallsystem behavior.
* They can be compile-time configured by defining
* them on the command line.
*/

// SYN requests nearer than RECENT_DROP_TIME are considered parts of the
// same attempt to connect and given the same block response (seconds)
#if !defined RECENT_DROP_TIME
#define RECENT_DROP_TIME 10
#endif

// The UPDATE_TICK_TIME is the minimal amount of time to consider when
// rehabilitating an ip. Since the probability is rounded to an integer,
// this should be large enough to make rounding errors small. (seconds)
#if !defined UPDATE_TICK_TIME
#define UPDATE_TICK_TIME 20
#endif

// The decay is the time it takes for the probability to halve.
// IPQBDB_INITIAL_DECAY is the fair amount initially set by default (seconds)
#if !defined IPQBDB_INITIAL_DECAY
#define IPQBDB_INITIAL_DECAY 120.0
#endif

// The decay increase is the amount added to the decay when the probability
// passes a given threshold. (seconds)
#if !defined IPQBDB_DECAY_ADDEND_ON_THRESHOLD
#define IPQBDB_DECAY_ADDEND_ON_THRESHOLD 30.0
#endif

// This is the probability threshold, here 50%, getting over which triggers
// the addition to the decay factor.
#if !defined IPQBDB_PROBABILITY_THRESHOLD
#define IPQBDB_PROBABILITY_THRESHOLD (RAND_MAX/2)
#endif

// This is the infinity decay, i.e. the amount that will cause
// the corresponding ip to be banned forever, no matter its probability value
// The test against this occurs to avoid calculating too slow decays.
// This value should not be used as a flag to have static records.
// (records that have this decay value are deleted jut like the other ones.)
#if !defined IPQBDB_NEVER_DECAY
#define IPQBDB_NEVER_DECAY 50457600400
#endif


#endif // CONFIG_NAMES_H_INCLUDED
