/* protocol.h -- understands and generates messages sent over the network
   Copyright (C) 2004 Maximiliano Pin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef PROTOCOL_H
#define PROTOCOL_H 1

#include "common.h"
#include "contact_list.h"

/* Protocol version. Changes when the program cannot communicate with
   older ipchat's anymore. It's sent in HELLO messages. */
#define PROTOCOL_VERSION 1

extern void pr_send_text (contact_t *contact, const char *txt);
extern void pr_send_hello (contact_t *contact);
extern void pr_send_beep (contact_t *contact);
extern int pr_msg_received (contact_t *contact, const BYTE *msg, int len);

#endif
