/* main.c -- main module
   Copyright (C) 2004 Maximiliano Pin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#define _POSIX_SOURCE

#include <signal.h>		/* SIG* */
#include <locale.h>		/* setlocale */
#include "common.h"
#include "uconfig.h"
#include "contact_list.h"
#include "transport.h"
#include "user_iface.h"
#include "uconfig.h"
#include "misc.h"

static void finish (int sig);

int
main (int argc, char **argv)
{
	signal (SIGPIPE, SIG_IGN);
	dmx_signal (SIGINT, finish);
	dmx_signal (SIGTERM, finish);
	setlocale (LC_ALL, "");
	
	CHECK_OK (ui_init ());

	ui_output_info ("\\b\\3" PACKAGE_STRING);
	ui_output_info ("\\b\\3----------");
	ui_output_info ("\\b(c) Maximiliano Pin");
	ui_output_info ("\\b(c) Julio A. Becerra");
	ui_output_info ("\\bType \"/help\" to access online help.");
	ui_output_info ("");

	/* TODO: check return val for these? leave or continue? */
	check_dir (".ipchat");
	check_dir (".ipchat/log");
	cf_load ();
	cl_load ();

	/* TODO: temporary, for tests; commenting out tr_init_checker()
	   below, this may be used to open lots of ipchats with the same user */
#if 0
	if (argc > 2 && !strcmp(argv[1], "--port")) {
		cfg.listen_port = (port_t) strtoul (argv[2], NULL, 10);
		ui_output_info ("Listen port set to: %u", cfg.listen_port);
	}
	if (argc > 4 && !strcmp(argv[3], "--nick")) {
		strcpy (cfg.nick, argv[4]);
		ui_redraw_nick ();
	}
#endif

	tr_init_resolver ();
	tr_init_server ();
	tr_init_checker ();

	dmx_main_loop ();

	ui_finish ();
	dmx_cleanup ();

	return 0;
error:
	return 1;
}

static void
finish (int sig)
{
	dmx_stop ();
}
