/*
   Copyright (C) 2011  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <utils.h>
#include <vector>
#include <string>
#include <sstream>
#include <set>

typedef std::multiset<guint32> guint32_list_type;
typedef guint32_list_type::iterator guint32_list_iterator_type;

static guint32_list_type udp_ports;

gboolean match_macaddr(gchar ** f,tvbuff_t *tvb)
{
	typedef std::vector<int> tab_int_type;

	tab_int_type tvbmac;

	for(int i=0;i<6;++i)
	{
		tvbmac.push_back(tvb_get_guint8(tvb,i));
	}
	gboolean match=FALSE;
	//tab_int_type mac;

	asterix_parameters_type* macline;
	guint num_macline;
	get_listen_addresses(&macline,&num_macline);

	for(guint i=0;i<num_macline;++i)
	{
		asterix_parameters_type& l = macline[i];
		if(l.enabled==ENABLED_FLAG && l.layer==MACLLC_TYPE)
		{
			std::string smac=l.addr;
			std::string::size_type spos=0;
			tab_int_type mac;
			for(int p = 0;p<6;++p)
			{
				std::string::size_type sep=smac.find_first_of(':',spos);
				std::string::size_type size=sep;
				if(size!=std::string::npos){
					size-=spos;
				}

				std::istringstream is(smac.substr(spos,size));
				int part;
				is >> std::hex >> part;
				mac.push_back(part);

				spos=sep+1;

			}
			if(mac==tvbmac)
			{
				match=TRUE;
				std::string family=match_strval(l.family,get_asterix_families());
				*f=g_strdup(family.c_str());
				break;
			}
		}
	}
	return match;

}

gboolean match_udp(gchar** f,guint32 port)
{
	asterix_parameters_type* macline;
	guint num_macline;
	get_listen_addresses(&macline,&num_macline);

	for(guint i=0;i<num_macline;++i)
		{
			asterix_parameters_type& l = macline[i];
			if(l.enabled==ENABLED_FLAG && l.layer==UDP_TYPE)
			{
				std::istringstream is(l.addr);
				guint32 enabled_port;
				is >> enabled_port;
				if(enabled_port==port)
				{
					std::string family=match_strval(l.family,get_asterix_families());
					*f=g_strdup(family.c_str());
					return TRUE;
				}
			}
		}

	return FALSE;
}

void push_udp_port(const guint32 pattern)
{
	udp_ports.insert(pattern);
}

gboolean udp_empty()
{
	gboolean ret=FALSE;
	if(udp_ports.empty()==true)
	{
		ret=TRUE;
	}
	return ret;
}
guint32 pop_udp_port()
{
	guint32 ret=0;
	if(udp_ports.empty()!=true)
	{
		guint32_list_iterator_type it=udp_ports.begin();
		ret=*it;
		udp_ports.erase(it);
	}
	return ret;
}
