#ifndef TREE_H
# define TREE_H

# ifdef HAVE_CONFIG_H
#  include <wireshark/config.h>
# endif

# ifdef __cplusplus
extern "C" {
# endif
# include <epan/packet.h>

    extern hf_register_info* get_network_tree_structure();
    extern size_t get_network_tree_structure_size();

    extern proto_tree* get_network_subtree(proto_tree *tree,int proto,const tvbuff_t *tvb);

    extern int update_network_tree(proto_tree *network_tree,const tvbuff_t *tvb);

    extern void register_network_subtree_array();

    extern void register_asterix_subtree_array();

    extern int* get_asterix_subtree_index();

#ifdef __cplusplus
}
#endif


#endif /* TREE_H */
