#include <Dump_Item_Iterator.hxx>
#include <iostream>

Dump_Item_Iterator::Dump_Item_Iterator(tvbuff_t *tvb):strip_null_(true),tree_(NULL),tvb_(tvb)
{
  
}

void Dump_Item_Iterator::dump_all()
{
  strip_null_=false;
}
void Dump_Item_Iterator::set_tree(proto_tree* tree)
{
  tree_=tree;
}
int Dump_Item_Iterator::operator()(const size_t&pos, const size_t&size,const intifada::Path_Name& full_name,intifada::Type& t)
{
  intifada::Path_Name path_name=full_name.get_path();
  
  try{
    std::string value=t.get_to_string();
    // don't print if strip_null is true and value=0 s . (v-)
    // print if s- + v
    if(strip_null_!=true || (value != "0" && value !="")){
      std::ostringstream os;
      os << full_name << "=" << value;
      proto_tree_add_text(tree_, tvb_, pos, size,os.str().c_str());
    }
  }catch(intifada::Description_Field_Unknow_Exception& ex){
    std::ostringstream es;
    es << "unknow field:full name:<"<<full_name<<">";
    proto_tree_add_text(tree_, tvb_, pos, -1,es.str().c_str());
  }
  return 0;
}

