#
#  Copyright (C) 2011  Stephane Pion
#  This file is part of Intifada.
#
#   Intifada is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Intifada is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
#

AC_DEFUN([INTIFADA_WIRESHARK_MACROS],
[
# ----------------------------------------------------------------------
# Add code to config.status to create an installable host dependent
# configuration file.
# ----------------------------------------------------------------------
AC_CONFIG_COMMANDS([utils/wireshark/macros.h],[

	outfile=utils/wireshark/macros.h
	stampfile=utils/wireshark/stamp-macros
	tmpfile=${outfile}T
	
	echo creating $outfile
	cat > $tmpfile << _EOF_
/*  -*- Mode: C -*-
 * --------------------------------------------------------------------
 * DO NOT EDIT THIS FILE!  It has been automatically generated
 * from:    configure.ac on host: `(hostname || uname -n) 2>/dev/null | sed 1q`
 * --------------------------------------------------------------------
 */

#ifndef INTIFADA_MACROS_H
# define INTIFADA_MACROS_H 1

_EOF_
	echo '# include <epan/uat.h>' >> $tmpfile 
	if test x$uat_fld_vs_args = x5; then
		echo '# define INTIFADA_UAT_FLD_VS(basename,field_name,fdesc,enum,desc) UAT_FLD_VS(basename,field_name,fdesc,enum,desc)' >> $tmpfile
	fi
	if test x$uat_fld_vs_args = x4; then
		echo '# define INTIFADA_UAT_FLD_VS(basename,field_name,fdesc,enum,desc) UAT_FLD_VS(basename,field_name,enum,desc)' >> $tmpfile
	fi
	if test x$uat_fld_cstring_isprint_args = x4; then
		echo '# define INTIFADA_UAT_FLD_CSTRING_ISPRINT(basename,field_name,fdesc,desc) UAT_FLD_CSTRING_ISPRINT(basename,field_name,fdesc,desc)' >> $tmpfile
	fi
	if test x$uat_fld_cstring_isprint_args = x3; then
		echo '# define INTIFADA_UAT_FLD_CSTRING_ISPRINT(basename,field_name,fdesc,desc) UAT_FLD_CSTRING_ISPRINT(basename,field_name,desc)' >> $tmpfile
	fi
	if test x$ac_cv_type_uat_post_update_cb_t = xyes; then
		cat >> $tmpfile << _EOF_
uat_t* intifada_uat_new(const char* name,
                           size_t size,
                           const char* filename,
                           gboolean from_profile,
                           void** data_ptr,
                           guint* num_items,
                           const char* category,
                           const char* help,
                           uat_copy_cb_t copy_cb,
                           uat_update_cb_t update_cb,
                           uat_free_cb_t free_cb,
                           uat_post_update_cb_t post_update_cb,
                           uat_field_t* flds_array)
                           {
	return uat_new(name,size,filename,from_profile,data_ptr,num_items,category,help,copy_cb,update_cb,free_cb,post_update_cb,flds_array);
                           }
_EOF_	
	else
		cat >> $tmpfile << _EOF_
uat_t* intifada_uat_new(const char* name,
                           size_t size,
                           const char* filename,
                           gboolean from_profile,
                           void** data_ptr,
                           guint* num_items,
                           const char* category,
                           const char* help,
                           uat_copy_cb_t copy_cb,
                           uat_update_cb_t update_cb,
                           uat_free_cb_t free_cb,
                           void* post_update_cb,
                           uat_field_t* flds_array)
                           {
	return uat_new(name,size,filename,from_profile,data_ptr,num_items,category,help,copy_cb,update_cb,free_cb,flds_array);
                           }
_EOF_
	fi
cat >> $tmpfile << _EOF_
# endif /* INTIFADA_MACROS_H */

_EOF_

	# replace file only if contents are differents
	cmp $tmpfile $outfile >/dev/null 2>&1 || ( cp $tmpfile $outfile ; echo timestamp > $stampfile )
	rm $tmpfile
	
],[
	uat_fld_vs_args=$uat_fld_vs_args
	uat_fld_cstring_isprint_args=$uat_fld_cstring_isprint_args
	ac_cv_type_uat_post_update_cb_t=$ac_cv_type_uat_post_update_cb_t
])
])
