#ifndef B_TREE_HXX
# define B_TREE_HXX

# include <iostream>

class Context
{
public:
	virtual ~Context(){}
};

template<typename TYPE>
class Context_T : public Context
{
public:
	virtual ~Context_T(){}

	virtual TYPE evaluate(const std::string& id)=0;
};

class B_Tree_Node
{
public:
	B_Tree_Node(const bool& terminal=false);
    virtual ~B_Tree_Node();

    virtual bool evaluate()const;

    virtual void dump(std::ostream &os, unsigned int depth=0)const=0;

    bool is_terminal()const;
protected:
    static std::string tabulation(unsigned int d);

private:
    bool _terminal;
};

template<typename DATA_TYPE>
class Terminal_Node : public B_Tree_Node
{
public:
	typedef B_Tree_Node inherited;
	typedef Context_T<DATA_TYPE> context_type;
public:
	/// Create a litteral Node
    explicit Terminal_Node(const DATA_TYPE& v);

    /// Create a symbolic Node
    /**
     * the litteral value of a symbolic node is grabbed when it needed
     */
    explicit Terminal_Node(const std::string& id,context_type *ctx);

    const DATA_TYPE& get_value()const;

    virtual void dump(std::ostream &os, unsigned int depth)const;
private:
    const std::string _id;
    context_type* _ctx;
    DATA_TYPE _value;
};

class Boolean_And_Node : public B_Tree_Node
{
public:
	typedef B_Tree_Node inherited;
	typedef B_Tree_Node hand_type;
public:
    explicit Boolean_And_Node(const hand_type*lhs,const hand_type*rhs);
    virtual ~Boolean_And_Node();


    virtual bool evaluate()const;

    virtual void dump(std::ostream &os, unsigned int depth)const;

private:
    const hand_type* _lhs;
    const hand_type* _rhs;
};


class Boolean_Or_Node : public B_Tree_Node
{
public:
	typedef B_Tree_Node inherited;
	typedef B_Tree_Node hand_type;
public:
    explicit Boolean_Or_Node(const hand_type*lhs,const hand_type*rhs);
    virtual ~Boolean_Or_Node();


    virtual bool evaluate()const;

    virtual void dump(std::ostream &os, unsigned int depth)const;

private:
    const hand_type* _lhs;
    const hand_type* _rhs;
};

class Boolean_Xor_Node : public B_Tree_Node
{
public:
	typedef B_Tree_Node inherited;
	typedef B_Tree_Node hand_type;
public:
    explicit Boolean_Xor_Node(const hand_type*lhs,const hand_type*rhs);
    virtual ~Boolean_Xor_Node();


    virtual bool evaluate()const;

    virtual void dump(std::ostream &os, unsigned int depth)const;

private:
    const hand_type* _lhs;
    const hand_type* _rhs;
};


class Boolean_Negation_Node : public B_Tree_Node
{
public:
	typedef B_Tree_Node inherited;
	typedef B_Tree_Node hand_type;
public:
    explicit Boolean_Negation_Node(const hand_type*node);
    virtual ~Boolean_Negation_Node();


    virtual bool evaluate()const;

    virtual void dump(std::ostream &os, unsigned int depth)const;

private:
    const hand_type* _node;
};

class Boolean_Equality_Node : public B_Tree_Node
{
public:
	typedef B_Tree_Node inherited;
	typedef B_Tree_Node hand_type;
public:
    explicit Boolean_Equality_Node(const hand_type*lhs,const hand_type*rhs);
    virtual ~Boolean_Equality_Node();


    virtual bool evaluate()const;

    virtual void dump(std::ostream &os, unsigned int depth)const;

private:
    const hand_type* _lhs;
    const hand_type* _rhs;
};

class Boolean_No_Equality_Node : public B_Tree_Node
{
public:
	typedef B_Tree_Node inherited;
	typedef B_Tree_Node hand_type;
public:
    explicit Boolean_No_Equality_Node(const hand_type*lhs,const hand_type*rhs);
    virtual ~Boolean_No_Equality_Node();


    virtual bool evaluate()const;

    virtual void dump(std::ostream &os, unsigned int depth)const;

private:
    const hand_type* _lhs;
    const hand_type* _rhs;
};


# include <intifada/boolean_interpreter/B_Tree.txx>

#endif // B_TREE_HXX
