/*
   Copyright (C) 2011  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INTIFADA_REGISTER_DISSECTOR_H
# define INTIFADA_REGISTER_DISSECTOR_H

#ifdef HAVE_CONFIG_H
#  include <wireshark/config.h>
#endif

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

# include <epan/packet.h>
# include <asterix_parameters_type.h>

extern void register_asterix(const char *name, const char *short_name, const char *filter_name);
extern int get_asterix_proto();
extern void register_mac_dissector(heur_dissector_t dissector);
extern void remove_mac_dissector();
extern void register_udp_dissector(dissector_t dissector,const guint32 pattern);
extern void remove_udp_dissectors();

extern void update_dissectors(asterix_parameters_type* parameters, guint size, heur_dissector_t heur_func,dissector_t dissector_func);

#ifdef __cplusplus
}
#endif

#endif // INTIFADA_REGISTER_DISSECTOR_H
