/*
   Copyright (C) 2011  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <register_dissector.h>
#include <utils.h>
#include <tree.h>
static int proto_asterix = -1;

static heur_dissector_t dissector=NULL;
static dissector_handle_t udp_asterix_handle;
static gboolean udp_asterix_handle_registered=FALSE;


void register_asterix(const char *name, const char *short_name, const char *filter_name)
{
	if (proto_asterix == -1) {

		// Asterix library can't be initialized here, because preferences aren't yet initialized
		//init_xml_asterix("/local/spion/usr/etc/intifada/asterix.xml");

		proto_asterix = proto_register_protocol (name,short_name,filter_name);

		proto_register_field_array(
				proto_asterix,
				get_network_tree_structure(),
				get_network_tree_structure_size()
		);


		register_network_subtree_array();
		register_asterix_subtree_array();


		register_preferences(proto_asterix);
	}
}

extern int get_asterix_proto()
{
	return proto_asterix;
}

void register_mac_dissector(heur_dissector_t d)
{
	if(proto_asterix==-1)
	{
		dissector=d;
		heur_dissector_add("eth", d, proto_asterix);
	}
}

void remove_mac_dissector()
{
	if(proto_asterix!=-1)
	{
		heur_dissector_delete("eth", dissector, proto_asterix);
	}
}

void register_udp_dissector(dissector_t dissector,const guint32 pattern)
{
	if(is_debug()==TRUE)printf("register udp %u\n",pattern);
	if(udp_asterix_handle_registered==FALSE)
	{
		udp_asterix_handle_registered=TRUE;
		udp_asterix_handle = create_dissector_handle(dissector, proto_asterix);
	}
	dissector_add("udp.port", pattern, udp_asterix_handle);
	push_udp_port(pattern);

}

void remove_udp_dissectors()
{
	while(udp_empty()!=TRUE)
	{
		guint32 pattern=pop_udp_port();
		dissector_delete("udp.port",pattern,udp_asterix_handle);
	}
}

void update_dissectors(asterix_parameters_type* parameters, guint size, heur_dissector_t heur_func,dissector_t dissector_func)
{
	unsigned int i;

	// clean dissectors
	remove_mac_dissector();
	remove_udp_dissectors();

	for(i=0;i<size;++i)
	{
		switch(parameters[i].layer)
		{
		case 0:
			// mac llc layer
			register_mac_dissector(heur_func);
			break;
		case 1:
			// udp layer only insert if port is enabled
			if(parameters[i].enabled!=1)
			{
				guint32 pattern=atoi(parameters[i].addr);
				register_udp_dissector(dissector_func,pattern);
			}
			break;
		}
		if(is_debug()==TRUE)printf("layer:%d enabled=%u addr=%s family=%d\n",parameters[i].layer,parameters[i].enabled,parameters[i].addr,parameters[i].family);
	}
}
