/*
   Copyright (C) 2011  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ASTERIX_PREFS_H
# define ASTERIX_PREFS_H

# ifdef HAVE_CONFIG_H
#  include <wireshark/config.h>
# endif


# ifdef __cplusplus
extern "C" {
# endif

# include <epan/prefs.h>
# include <epan/value_string.h>
# include <epan/uat.h>
# include <asterix_parameters_type.h>

extern void register_preferences(int proto);

extern value_string* get_asterix_families();

extern void get_listen_addresses(asterix_parameters_type** parameters,guint* size);

extern gboolean is_dump_all();

extern gboolean is_debug();

extern void uat_destroy(uat_t* uat);

#define ENABLED_FLAG 0
#define DISABLED_FLAG 1
#define MACLLC_TYPE 0
#define UDP_TYPE 1

#ifdef __cplusplus
}
#endif


#endif /* ASTERIX_PREFS_H */
