/*
   Copyright (C) 2011  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <packet-asterix.h>

#include <tree.h>
#include <prefs.h>
#include <intifada_wrapper.h>
#include <utils.h>
#include <register_dissector.h>
#include <dissect_mac_asterix.h>
#include <dissect_udp_asterix.h>

void proto_register_asterix(void)
{
	register_asterix("Eurocontrol Asterix Format","Asterix","asterix");
}

void proto_reg_handoff_asterix(void)
{
	if(is_debug()==TRUE)printf("proto_reg_handoff_asterix\n");
	static int prefs_initialized = FALSE;
	if (!prefs_initialized) {
		apply_prefs();
	}
}

void apply_prefs()
{
	asterix_parameters_type* parameters;
	guint size;
	get_listen_addresses(&parameters,&size);
	update_dissectors(parameters,size,dissect_mac_asterix,dissect_udp_asterix);

}
