/*
   Copyright (C) 2011  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <dissect_mac_asterix.h>

#include <tree.h>
#include <prefs.h>
#include <intifada_wrapper.h>
#include <utils.h>
#include <register_dissector.h>

gboolean dissect_mac_asterix(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree)
{
	gchar* family=NULL;
	gboolean match;

	match = match_macaddr(&family,tvb);
	if(match==TRUE)
	{
		if (check_col(pinfo->cinfo, COL_PROTOCOL)) {
			col_set_str(pinfo->cinfo, COL_PROTOCOL, "ASTERIX");
		}
		/* Clear out stuff in the info column */
		if (check_col(pinfo->cinfo,COL_INFO)) {
			col_clear(pinfo->cinfo,COL_INFO);
		}

		if (tree!=NULL) { /* we are being asked for details */
			// decodate asterix here

			proto_tree *network_tree = get_network_subtree(tree,get_asterix_proto(),tvb);
			int offset=update_network_tree(network_tree,tvb);


			guint16 total_size= tvb_get_ntohs(tvb,12);// ssap+dsap+ctl+data

			int asterix_offset = offset + 3;
			int asterix_bytes = total_size-3;//tvb_length_remaining(tvb,asterix_offset)-7;
			//void *void_asterix_stream=tvb_memdup(tvb, asterix_offset,asterix_bytes);
			if(is_debug()==TRUE)printf("asterix size=%d\n",asterix_bytes+asterix_offset);
			void *void_asterix_stream=tvb_memdup(tvb, 0,asterix_bytes+asterix_offset);
			const uint8_t* asterix_stream=(const uint8_t*)void_asterix_stream;

			int *index=get_asterix_subtree_index();
			asterix_decode(family,asterix_stream,asterix_offset,asterix_bytes+asterix_offset,network_tree,tvb,index);
			g_free(family);
			g_free(void_asterix_stream);
		}
	}else{
		return FALSE;
	}
	return TRUE;

}
