/*
   Copyright (C) 2011  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ASTERIX_PARAMETERS_TYPE_H
# define ASTERIX_PARAMETERS_TYPE_H

# ifdef HAVE_CONFIG_H
#  include <wireshark/config.h>
# endif


# ifdef __cplusplus
extern "C" {
# endif

# include <epan/prefs.h>
//# include <epan/value_string.h>
//# include <epan/uat.h>

/// Structure handling dump network parameters
/**
 * @param family asterix family
 * @param layer network layer (mac or UDP)
 * @param macaddr network address (mac address or ip:port address)
 * @param enabled enabled flag
 */
typedef struct {
	guint family;
	guint layer;
	char* addr;
	guint enabled;
} asterix_parameters_type;

#ifdef __cplusplus
}
#endif


#endif /* ASTERIX_PARAMETERS_TYPE_H */
