#ifndef DUMP_ITERATOR_HXX
# define DUMP_ITERATOR_HXX

# ifdef HAVE_CONFIG_H
#  include <wireshark/config.h>
# endif

# include <intifada/Record_Iterator.hxx>
# include <Dump_Item_Iterator.hxx>

// avoid bug in wireshark headers which don't include C++ protection
extern "C"{
# include <epan/proto.h>
}

class Dump_Iterator:public intifada::Record_Iterator
{
public:
  Dump_Iterator(proto_tree *tree,tvbuff_t *tvb,int& idx);

  void error(const std::string& err);

  void dump_all();
  /// Called when a block began
  virtual int operator()(uint8_t c);

  /// virtual Call operator
  /**
   * Called when a record is encountered
   *
   * \param i record pointer
   * \param b block id in message (first block in message id is 0)
   * \param r record id in block (first record in block is 0)
   */
  virtual int operator()(
			 intifada::Record_Iterator::record_type& i,
			 const intifada::Message::block_list_size_t& b,
			 const intifada::Block::record_list_size_t& r);
private:
  Dump_Item_Iterator it_;

  proto_tree *tree_;
  tvbuff_t *tvb_;
  int& idx_;

  proto_item* item_cat_;
  proto_item* item_bloc_;
};

#endif // DUMP_ITERATOR_HXX
