#include <Dump_Iterator.hxx>

#include <intifada/Record.hxx>
#include <prefs.h>
Dump_Iterator::Dump_Iterator(proto_tree *tree,tvbuff_t *tvb,int& idx):it_(tvb),tree_(tree),tvb_(tvb),idx_(idx),item_cat_(NULL),item_bloc_(NULL){}

void Dump_Iterator::dump_all()
{
  it_.dump_all();
}

void Dump_Iterator::error(const std::string& err)
{
  if(is_debug()==TRUE)printf("error set:%s\n",err.c_str());

  item_cat_ = proto_tree_add_text(tree_, tvb_, 16,-1,err.c_str());
  proto_item_add_subtree(item_cat_,idx_);

}

/// Called when a block began
int Dump_Iterator::operator()(uint8_t c)
{
  item_cat_ = proto_tree_add_text(tree_, tvb_, 16,-1,"Asterix cat %02x (%03u)",c,c);
  return 0;
}

/// virtual Call operator
/**
 * Called when a record is encountered
 *
 * \param i record pointer
 * \param b block id in message (first block in message id is 0)
 * \param r record id in block (first record in block is 0)
 */
int Dump_Iterator::operator()(
			      intifada::Record_Iterator::record_type& i,
			      const intifada::Message::block_list_size_t& b,
			      const intifada::Block::record_list_size_t& r)
{
  proto_tree* bloc_tree = proto_item_add_subtree(item_cat_, idx_);
  item_bloc_=proto_tree_add_text(bloc_tree, tvb_, 16,-1,"bloc %u record %u",b,r);
  proto_tree* record_tree = proto_item_add_subtree(item_bloc_,idx_);
  it_.set_tree(record_tree);
  i.foreach(it_,intifada::Path_Name());
  return 0;
}
