#ifndef DUMP_ITEM_ITERATOR_HXX
# define DUMP_ITEM_ITERATOR_HXX

# ifdef HAVE_CONFIG_H
#  include <wireshark/config.h>
# endif

# include <intifada/Data_Field.hxx>

// avoid bug in wireshark headers which don't include C++ protection
extern "C"{
# include <epan/proto.h>
}

class Dump_Item_Iterator : public intifada::Data_Field::Functor
{
public:
  Dump_Item_Iterator(tvbuff_t *tvb);

  void dump_all();
  void set_tree(proto_tree* tree);
  virtual int operator()(const size_t&pos, const size_t&size,const intifada::Path_Name& full_name,intifada::Type& t);
private:
  bool strip_null_;
  proto_tree *tree_;
  tvbuff_t *tvb_;

};


#endif // DUMP_ITEM_ITERATOR_HXX
