/*
   Copyright (C) 2009, 2010  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <imc.hxx>

#include <intifada/Configuration_Internal_Parser.hxx>
#include <fstream>
#include <Options.hxx>
#include <Check_Operation.hxx>
#include <Dump_Operation.hxx>
#include <cstring>

#include <intifada/Configuration_Internal_Reader.hxx>
#include <intifada/Configuration_XML_Reader.hxx>
#include <intifada/Record_Repository.hxx>

#include <Pure_Asterix_Source.hxx>
#include <PCAP_Asterix_Source.hxx>
#include <Standalone_PCAP_Asterix_Source.hxx>
#include <Message_Database_Source.hxx>

static Options options;

#if 0
void check_text_database(Operation& op_asterix)
throw(intifada::Parsing_Input_Length_Exception)
{
  intifada::Configuration_Internal_Parser p;
  p.add_key("id",intifada::Configuration_Internal_Parser::STRING);
  p.add_key("family",intifada::Configuration_Internal_Parser::STRING);
  p.add_key("message_count",intifada::Configuration_Internal_Parser::STRING);
  p.add_key("message",intifada::Configuration_Internal_Parser::INTEGER_ARRAY);
  p.add_key("message_status",intifada::Configuration_Internal_Parser::STRING);

  std::string dbt=INTIFADA_TOP_SRCDIR;
  dbt+="/utils/imc/";
  dbt+="Message_Database.dbt";
  std::ifstream file(dbt.c_str());

  bool check=false;
  std::string idx=options.get_idx();
  std::string midx;
  std::string family;
  std::string status="PASS";
  if(!file)
    {
    std::cout << dbt << " introuvable" << std::endl;
    }
  while(file)
    {
    p.parse(file);
    if(file)
      {
      const std::string &key=p.get_key();
      if(key=="family")
        {
        p.get_arg(family);
        }
      else if(key=="id")
        {
        std::string id;
        p.get_arg(id);
        check=options.check_exist(id);
        }
      else if(key=="message_count")
        {
        p.get_arg(midx);
        }
      else if(key=="message_status")
        {
        // expected status (default=PASS)
        // PASS (assertion is true)
        // XFAIL (fail, but it's normal)
        // Parsing_Input_Length_Exception (expected error on input length problem)
        p.get_arg(status);
        }
      else if(key=="message" && check==true && (idx.empty()!=false||(idx==midx)))
        {
        intifada::Configuration_Internal_Parser::int_array_type array;
        p.get_arg(array);
        uint8_t *m=new uint8_t[array.size()];
        for(
            intifada::Configuration_Internal_Parser::int_array_type::size_type i=0;
            i<array.size();
            ++i
        ){
          m[i]=array[i];
        }

        op_asterix(family,midx,m,array.size(),status);
        delete[]m;
        // std::cout << family <<":"<<midx <<std::endl;
        }
      }
    else
      {
      }
    }
}
#endif
int
main(int argc, char**argv)
{
  int idx=0;
  try{
    // clog.insert_mask("Condition");
    // clog.insert_mask("Configuration_XML_Reader");
    // clog.insert_mask("Configuration_Reader");
    // clog.insert_mask("Record");
    // clog.insert_mask("Foreach_Field_Iterator");
    // clog.insert_mask("Configuration_Reader");
    // clog.insert_mask("Field_Specification_Data");
    // clog.insert_mask("Field_Iterator_Size");
    // clog.insert_mask("Check_Item_Iterator");
    // clog.insert_mask("Repetitive_Length_Data_Field");
    // clog.insert_mask("Extended_Length_Data_Field");
    // clog.insert_mask("size debug");
    // clog.insert_mask("stream pos");
    // clog.insert_mask("String_Type");
    // clog.insert_mask("Memory_Allocation");
    // clog.insert_mask("Configuration_Internal_Reader");
    // clog.insert_mask("Data_Field_Characteristics_List");
    // clog.insert_mask("pcap");
    handle_options(options,argc,argv);

    std::string asterix_description=INTIFADA_TOP_SRCDIR;
    std::string asterix_validation=INTIFADA_TOP_SRCDIR;
    if(options.get_internal_description()==true)
      {
      asterix_description+="/test.kv";
      }
    else
      {
      asterix_description +="/asterix.xml";
      asterix_validation +="/asterix.dtd";
      }
    std::string alternate_asterix_description=options.get_asterix_description();
    std::string alternate_asterix_validation=options.get_asterix_validation();
    if(alternate_asterix_description.empty()!=true){
      asterix_description=alternate_asterix_description;
    }
    if(alternate_asterix_validation.empty()!=true){
      asterix_validation=alternate_asterix_validation;
    }


    intifada::Configuration_Reader *p=NULL;
    // Reading asterix description
    if(options.get_internal_description()==true)
      {
      p= new intifada::Configuration_Internal_Reader(asterix_description);
      }
    else
      {
      p= new intifada::Configuration_XML_Reader(asterix_description,asterix_validation);
      }


    int opened=p->open();
    if(opened!=0){
      std::cerr << "Error opening asterix description (" << asterix_description << ")" << std::endl;
      exit(EXIT_FAILURE);
    }
    // Loading repository with asterix description
    intifada::Record_Repository* rep=intifada::Record_Repository::instance();
    p->parse(rep);
    Operation *op_asterix=NULL;
    if(options.get_dump()==false){
      op_asterix = new Check_Operation(rep);
    }else{
      op_asterix = new Dump_Operation(rep,options.get_dump_type());
    }
    Source_Reader* source_type=NULL;
    if(options.get_type()=="INTERNAL"){
      std::string dbt=INTIFADA_TOP_SRCDIR;
      dbt+="/utils/imc/";
      dbt+="Message_Database.dbt";
      source_type=new Message_Database_Source(dbt,options,*op_asterix);
      // check_internal_database(*op_asterix);
      // check_text_database(*op_asterix);
      // dump_internal_database();
    }else if(options.get_type()=="PURE"){
      source_type=new Pure_Asterix_Source(options.get_source(),options.get_family(),*op_asterix);
#if 0
      std::ifstream ifile(options.get_source().c_str());
      idx=0;
      while(ifile){
        char *astmsg=NULL;
        uint16_t size;
        char asthead[3];
        ifile.read(asthead,3);
        if(ifile){
          size=((asthead[1]& 0xff) << 8) | (asthead[2] & 0xff);
          astmsg=new char[size];
          ::memcpy(astmsg,asthead,3);
          char *ap=astmsg;
          ap+=3;
          ifile.read(ap,size-3);
        }
        if(ifile){
          // handle asterix msg here
          //std::cout <<"/ handle asterix msg here\n";
          const uint8_t*m=reinterpret_cast<const uint8_t*>(astmsg);
          uint16_t msg_size=size;
          std::ostringstream os;
          os << idx;
          (*op_asterix)(options.get_family(),os.str(),m,msg_size,"PASS");
        }
        if(astmsg!=NULL){
          delete[]astmsg;
        }
        ++idx;
      }
      ifile.close();
#endif
    }else if(options.get_type()=="PCAP"){
      source_type=new PCAP_Asterix_Source(options.get_source(),options.get_family(),*op_asterix);
    }else if(options.get_type()=="LIMITED_PCAP"){
      source_type=new Standalone_PCAP_Asterix_Source(options.get_source(),options.get_family(),*op_asterix);
    }else{
      std::cout << "type:"<<options.get_type()<< " not yet implemented" << std::endl;
    }
    if(source_type!=NULL)
      {
      int opened_state=source_type->open();
      if(opened_state!=0)
        {
        std::cerr << "Error opening source stream" << std::endl;
        exit(EXIT_FAILURE);
        }
      if(options.get_userdata().empty()!=true)
        {
          int filter_state = source_type->set_filter(options.get_userdata());
          if(filter_state!=0)
            {
            std::cerr << "Error setting filter" << std::endl;
            exit(EXIT_FAILURE);
            }
        }
      int size=0;
      do
        {
        size=source_type->read();
        (*source_type)();
        }while(size > 0);
      source_type->close();
      }

    exit(EXIT_SUCCESS);
  }catch(intifada::Description_Field_Unknow_Exception & ex){
    std::cerr << "Unknow field:"<<ex.get_name()<<std::endl;
    exit(EXIT_FAILURE);
  }catch(intifada::Parsing_Input_Length_Exception & ex){
    std::cerr << "Invalid size:fatal error" <<std::endl;
    exit(EXIT_FAILURE);
  }catch(intifada::Parsing_Unknow_Category & ex){
    std::cerr << "Invalid category:fatal error (got "
        << static_cast<uint16_t>(ex.get_category())
        << " for " << ex.get_family() << " family at "
        << ex.get_error_position() << " bytes from asterix begining)"
        << std::endl;
    exit(EXIT_FAILURE);

  }
}
