/*
   Copyright (C) 2010  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <Standalone_PCAP_Asterix_Source.hxx>
#include <Operation.hxx>
#include <cstring>
#include <sstream>
#include <intifada/Logger.hxx>

Standalone_PCAP_Asterix_Source::Standalone_PCAP_Asterix_Source(const std::string& filename,const std::string& family,Operation &op):
filename_(filename),
ifile_(),
global_header_(),
swap_order_(false),
packet_header_(),
buf_(NULL),
buf_size_(0),
macs_list_(),
family_(family),
idx_(0),
op_(op)
{}

Standalone_PCAP_Asterix_Source::~Standalone_PCAP_Asterix_Source()
{
  if(buf_!=NULL)
    {
    delete[] buf_;
    }
}

int Standalone_PCAP_Asterix_Source::open()
{
  idx_=0;
  int ret=-1;
  ifile_.open(filename_.c_str());
  if(ifile_)
    {
    // read the global header
    // acquire magic number
    ret=read_global_header();

    }
  return ret;
}

int Standalone_PCAP_Asterix_Source::close()
{
  int ret=-1;
  ifile_.close();
  if(ifile_)
    {
    ret=0;
    }
  return ret;
}

int Standalone_PCAP_Asterix_Source::read()
{
  if(ifile_)
    {
    // Read packet header
    read_packet_header();
    read_packet_data();
    }

  return buf_size_;
}

void Standalone_PCAP_Asterix_Source::operator()()
{
  std::ostringstream os;
  os << idx_;
  clog("pcap") << "family:" << family_ << " size:"<<buf_size_ << " asterix begining:" << std::hex
      << "0x" << static_cast<uint16_t>(buf_[0]) << ":"
      << "0x" << static_cast<uint16_t>(buf_[1]) << ":"
      << "0x" << static_cast<uint16_t>(buf_[2]) << std::dec << cendl;

  op_(family_,os.str(),buf_,buf_size_,"PASS");
}

void Standalone_PCAP_Asterix_Source::register_mac_address(const std::string& mac)
{
  //uint32_t mac=0;

  //macs_list_
}

int Standalone_PCAP_Asterix_Source::read_global_header()
{
  int ret=0;
  try
  {
    read_bytes(global_header_.magic_number);
    if(global_header_.magic_number==0xa1b2c3d4)
      {
      swap_order_=false;
      }
    else if(global_header_.magic_number==0xd4c3b2a1)
      {
      swap_order_=true;
      }
    else
      {
      ret=-1;
      }
    if(ret==0)
      {
      read_bytes(global_header_.version_major);
      read_bytes(global_header_.version_minor);
      read_bytes(global_header_.thiszone);
      read_bytes(global_header_.sigfigs);
      read_bytes(global_header_.snaplen);
      read_bytes(global_header_.network);
      }
  }
  catch(...)
  {
    ret=-1;
  }
  clog("pcap") << "pcap global header status:" << ret << cendl;
  clog("pcap") << "pcap file:magic_number:0x" << std::hex << global_header_.magic_number << std::dec << cendl;
  clog("pcap") << "pcap file:version:" << global_header_.version_major << "." << global_header_.version_minor << cendl;
  clog("pcap") << "pcap file:timezone:" << global_header_.thiszone << cendl;
  clog("pcap") << "pcap file:sigfigs:" << global_header_.sigfigs << cendl;
  clog("pcap") << "pcap file:snaplen:" << global_header_.snaplen << cendl;
  clog("pcap") << "pcap file:network:" << global_header_.network << cendl;
  return ret;
}

int Standalone_PCAP_Asterix_Source::read_packet_header()
{
  int ret=0;
  try
  {
    read_bytes(packet_header_.ts_sec);
    read_bytes(packet_header_.ts_usec);
    read_bytes(packet_header_.incl_len);
    read_bytes(packet_header_.orig_len);
  }
  catch(...)
  {
    ret=-1;
  }
  clog("pcap") << "pcap packet header status:" << ret << cendl;
  clog("pcap") << "pcap ts_sec:"<< packet_header_.ts_sec << cendl;
  clog("pcap") << "pcap ts_usec:"<< packet_header_.ts_usec << cendl;
  clog("pcap") << "pcap incl_len:"<< packet_header_.incl_len << cendl;
  clog("pcap") << "pcap orig_len:"<< packet_header_.orig_len << cendl;

  return ret;
}

int Standalone_PCAP_Asterix_Source::read_packet_data()
{
  uint8_t* buf=new uint8_t[packet_header_.incl_len];
  ifile_.read(reinterpret_cast<char*>(buf),packet_header_.incl_len);


  buf_size_=-1;
  size_t asterix_offset=packet_header_.incl_len;
  size_t data_length=packet_header_.incl_len;
  bool handled_layer=true;
  if(global_header_.network==1)
    {
    // frame:
    // 111111 222222 33 44 5 XXX...XXXXYYY CCCC
    // 1: source mac
    // 2: target mac
    // 3: data size (44+5+X)
    // 4: SAP
    // 5: type
    // X: data
    // Y:padding
    // C:CRC

    // skip all non asterix part for ethernet:
    // if France: source addr(6)+target addr(6)+length(2)+sap(2)+service(1)=17 bytes skipped
    // asterix data length is 'length'-3 (ssap+dsap+service)
    //
    asterix_offset=17;
    data_length=(buf[12]<<8)|buf[13];
    data_length-=3;
    }
  // add here all layer types (just compute asterix message offset)
  else
    {
    handled_layer=false;
    }

int ret=-1;
  if(handled_layer!=false)
    {
    ret=0;
    buf_size_=data_length;//-asterix_offset;
    if(buf_!=NULL)
      {
      delete[] buf_;
      }
    buf_=new uint8_t[buf_size_];
    ::memcpy(static_cast<void*>(buf_),&buf[asterix_offset],buf_size_);
    }
  delete[]buf;
  return ret;
}
