/*
   Copyright (C) 2010  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <Pure_Asterix_Source.hxx>
#include <Operation.hxx>
#include <cstring>
#include <sstream>

Pure_Asterix_Source::Pure_Asterix_Source(const std::string& filename,const std::string& family,Operation &op):
filename_(filename),
ifile_(),
buf_(NULL),
buf_size_(0),
family_(family),
idx_(0),
op_(op)
{}

Pure_Asterix_Source::~Pure_Asterix_Source()
{
  if(buf_!=NULL)
    {
    delete[] buf_;
    }
}

int Pure_Asterix_Source::open()
{
  idx_=0;
  ifile_.open(filename_.c_str());
  int ret=-1;
  if(ifile_)
    {
    ret=0;
    }
  return ret;
}

int Pure_Asterix_Source::close()
{
  ifile_.close();
  int ret=-1;
  if(ifile_)
    {
    ret=0;
    }

  return ret;
}

int Pure_Asterix_Source::read()
{
  if(buf_!=NULL)
    {
    delete[] buf_;
    }
  buf_size_=-1;
  if(ifile_)
    {
    char asthead[3];
    ifile_.read(asthead,3);
    if(ifile_)
      {
      buf_size_=((asthead[1]& 0xff) << 8) | (asthead[2] & 0xff);
      buf_=new uint8_t[buf_size_];
      ::memcpy(static_cast<void*>(buf_),asthead,3);
      uint8_t* ap=buf_;
      ap+=3;
      ifile_.read(reinterpret_cast<char*>(ap),buf_size_-3);
      ++idx_;
      }
    if(!ifile_)
      {
      delete[]buf_;
      buf_=NULL;
      buf_size_=-1;
      }
    }
  return buf_size_;
}

void Pure_Asterix_Source::operator()()
{
  std::ostringstream os;
  os << idx_;
  op_(family_,os.str(),buf_,buf_size_,"PASS");
}
