/*
   Copyright (C) 2009, 2010  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <Dump_Operation.hxx>
#include <intifada/Message.hxx>
#include <Dump_Iterator.hxx>

Dump_Operation::Dump_Operation(intifada::Record_Repository* rep,const std::string& dump_type):inherited(rep),dump_type_(dump_type){}

int Dump_Operation::operator()(
    const std::string& family,
    const std::string&,
    const uint8_t*m,
    uint16_t msg_size,
    const std::string&)
    throw(intifada::Parsing_Input_Length_Exception)
    {

  intifada::Message msg(rep_,family);

  intifada::Stream::size_type s;
  s = msg.set_stream(m,0,msg_size);
  Dump_Iterator cit;
  if(dump_type_=="ALL"){
    cit.dump_all();
  }

  intifada::Record_Iterator_List ril;
  ril.register_iterator(cit);
  msg.foreach(ril);
  return 0;
    }
