#
#  Copyright (C) 2009  Stephane Pion
#  This file is part of Intifada.
#
#   Intifada is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Intifada is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
#

AC_DEFUN([INTIFADA_MAP],
[
# ----------------------------------------------------------------------
# Add code to config.status to create an installable host dependent
# configuration file.
# ----------------------------------------------------------------------
AC_CONFIG_COMMANDS([intifada/os_wrappers/map.hxx],[

	outfile=intifada/os_wrappers/map.hxx
	stampfile=intifada/os_wrappers/stamp-map
	tmpfile=${outfile}T
	
	echo creating $outfile
	cat > $tmpfile << _EOF_
/*  -*- Mode: C -*-
 * --------------------------------------------------------------------
 * DO NOT EDIT THIS FILE!  It has been automatically generated
 * from:    configure.ac on host: `(hostname || uname -n) 2>/dev/null | sed 1q`
 * --------------------------------------------------------------------
 */

#ifndef INTIFADA_OS_WRAPPERS_MAP_HXX
# define INTIFADA_OS_WRAPPERS_MAP_HXX 1

_EOF_
	echo '# include<map>' >> $tmpfile 
	if test x$intifada_have_unordered = xyes; then
		echo '# include <unordered_map>' >> $tmpfile
		echo '# define INTIFADA_HAVE_UNORDERED_MAP 1' >> $tmpfile
	fi
cat >> $tmpfile << _EOF_
# endif /* INTIFADA_OS_WRAPPERS_MAP_HXX */

_EOF_

	# replace file only if contents are differents
	cmp $tmpfile $outfile >/dev/null 2>&1 || cp $tmpfile $outfile
	rm $tmpfile
	
],[
  	intifada_have_unordered=$intifada_have_unordered
])
])
