/*
   Copyright (C) 2009 Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ICHECKER_HXX_
# define ICHECKER_HXX_

# include <set>
# include <string>
# include <intifada/Data_Field.hxx>
# include <intifada/Record.hxx>
# include <intifada/Record_Iterator_List.hxx>


class Options
  {
private:
  typedef std::set<std::string> desc_type;
  typedef desc_type::iterator desc_iterator_type;
  typedef desc_type::const_iterator desc_const_iterator_type;
  typedef std::pair<desc_iterator_type,bool> desc_pair_type;
public:
  Options();
public:
  void set_asterix_description(const char* f);
  const std::string& get_asterix_description()const;
  void set_asterix_validation(const char* f);
  const std::string& get_asterix_validation()const;

  void add_check(const char* c);
  bool check_exist(const std::string& c)const;
  void set_idx(const char* i);
  int get_idx()const;
  void set_source(const char* s);
  const std::string& get_source()const;

  void set_type(const std::string& t);

  const std::string& get_type()const;
  void set_dump(const bool&d);
  bool get_dump()const;
  void set_dump_type(const std::string& t);

  const std::string& get_dump_type()const;
  void set_family(const std::string& t);

  const std::string& get_family()const;

  bool get_internal_description()const;
  void set_internal_description(const bool& t);

private:
  std::string asterixDescription_;
  std::string asterixValidation_;
  desc_type checks_;
  mutable int idx_;
  std::string source_;
  std::string source_type_;
  bool dump_;
  std::string dump_type_;
  std::string family_;
  bool internal_description_;
  };

void help();
int handle_options(int argc, char**argv);

/// Data field functor
/**
 * operator() is Called for each encountered data field
 */
class Check_Item_Iterator : public intifada::Data_Field::Functor
  {
  public:
    Check_Item_Iterator();
    virtual int operator()(const intifada::Stream::size_type&,const intifada::Stream::size_type&,const intifada::Path_Name& full_name,intifada::Type& t);
    void set_record(intifada::Record* r);
  private:
    intifada::Record* record_;
  };

class Dump_Item_Iterator : public intifada::Data_Field::Functor
  {
  public:
    Dump_Item_Iterator();
    void dump_all();

    virtual int operator()(
        const intifada::Stream::size_type&stream_pos
        ,const intifada::Stream::size_type& stream_size
        ,const intifada::Path_Name& full_name
        ,intifada::Type& t);
  private:
    bool strip_null_;

  };

class Check_Iterator:public intifada::Record_Iterator
  {
  public:
    Check_Iterator(intifada::Message& msg);
    /// Called when a block began
    virtual int operator()(uint8_t c);
    /// virtual Call operator
    /**
     * Called when a record is encountered
     *
     * \param i record pointer
     * \param b block id in message (first block in message id is 0)
     * \param r record id in block (first record in block is 0)
     */
    virtual int operator()(
        intifada::Record_Iterator::record_type& i,
        const intifada::Message::block_list_size_t& /*b*/,
        const intifada::Block::record_list_size_t& /*r*/);
  private:
    Check_Item_Iterator it_;
    intifada::Message& msg_;
    intifada::Block* block_;
  };

class Dump_Iterator:public intifada::Record_Iterator
  {
  public:
    Dump_Iterator();

    void dump_all();
    /// Called when a block began
    virtual int operator()(uint8_t c);

    /// virtual Call operator
    /**
     * Called when a record is encountered
     *
     * \param i record pointer
     * \param b block id in message (first block in message id is 0)
     * \param r record id in block (first record in block is 0)
     */
    virtual int operator()(
        intifada::Record_Iterator::record_type& i,
        const intifada::Message::block_list_size_t& b,
        const intifada::Block::record_list_size_t& r);
  private:
    Dump_Item_Iterator it_;
  };

class Operation
  {
public:
  Operation(intifada::Record_Repository* rep);
  virtual ~Operation();

  virtual int operator()(const std::string& family,int midx,const uint8_t*m, uint16_t msg_size)
  throw(intifada::Parsing_Input_Length_Exception)=0;
protected:
  intifada::Record_Repository* rep_;
  };

class Check_Operation : public Operation
  {
public:
  typedef Operation inherited;
public:
  Check_Operation(intifada::Record_Repository* rep);
  virtual int operator()(const std::string& family,int midx,const uint8_t*m, uint16_t msg_size)
  throw(intifada::Parsing_Input_Length_Exception);
  };

class Dump_Operation : public Operation
  {
  public:
    typedef Operation inherited;
  public:
    Dump_Operation(intifada::Record_Repository* rep,const std::string& dump_type);
    virtual int operator()(const std::string& family,int midx,const uint8_t*m, uint16_t msg_size)
    throw(intifada::Parsing_Input_Length_Exception);
  private:
    std::string dump_type_;
  };

void check_internal_database(Operation& op_asterix)
throw(intifada::Parsing_Input_Length_Exception);


#endif // ICHECKER_HXX_
