/*
   Copyright (C) 2009 Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CONFIGURATION_INTERNAL_PARSER_HXX_
# define CONFIGURATION_INTERNAL_PARSER_HXX_

# include <string>
# include <vector>
# include <intifada/Map.hxx>

namespace intifada
  {
    class Configuration_Internal_Parser
      {
      public:
        typedef enum{
          VOID,
          LONGNAME,
          TYPE,
          BYTE,
          START,
          SIZE,
          VALUE,
          FORCE,
          FRN,
          DESC,
          ID,
          CAT,
          TAB
        }arg_type;

      private:
        typedef std::vector<std::pair<std::string,std::string> > cmds_list_type;
        typedef cmds_list_type::iterator cmds_iterator_list_type;

        typedef intifada::Map<std::string,arg_type> id_list_type;
        typedef id_list_type::iterator id_list_iterator_type;
        typedef id_list_type::pair id_list_pair_type;
      public:
        Configuration_Internal_Parser();
        virtual ~Configuration_Internal_Parser();

      public:
        int add_key(const std::string& key,const arg_type& type);
        void parse(std::istream& is);

        void find_arg(const arg_type& at,std::string& av)const;
        void find_arg(const arg_type& at,int& av)const;
        void find_arg(const arg_type& at,uint8_t& av)const;

        int add_arg(const arg_type& at,const std::string& av);

      private:
        cmds_list_type cmds_;
        id_list_type keys_;
      };
  }

#endif // CONFIGURATION_INTERNAL_PARSER_HXX_
