/*
   Copyright (C) 2009  Stephane Pion
   This file is part of Intifada.

    Intifada is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Intifada is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <intifada/Configuration_Internal_Parser.hxx>
#include <sstream>

intifada::Configuration_Internal_Parser::Configuration_Internal_Parser():keys_(){}

intifada::Configuration_Internal_Parser::~Configuration_Internal_Parser(){}

int intifada::Configuration_Internal_Parser::add_key(const std::string& key,const arg_type& type)
  {
    id_list_pair_type p=keys_.insert(std::make_pair(key,type));
    int ret=-1;
    if(p.second!=false)
      {
        ret=0;
      }
    return ret;
  }

void intifada::Configuration_Internal_Parser::parse(std::istream& is)
  {
    uint8_t c;
    std::string key;
    bool key_mode=true;
    std::string arg;
    while(is)
      {
        // get key
        c=is.get();
        if(key_mode==true)
          {
            if(c!=':')
              {
                key+=c;
              }
            else
              {

              }
          }
      }
  }

#if 0
void intifada::Configuration_Internal_Parser::find_arg(const arg_type& at,std::string& av)const
{
  arg_list_const_iterator_type it = args_.find(at);
  if(it!=args_.end())
    {
      av=(*it).second;
    }
  else
    {
      throw std::domain_error("no arg");
    }

  return;
}

void intifada::Configuration_Internal_Parser::find_arg(const arg_type& at,int& av)const
{
  arg_list_const_iterator_type it = args_.find(at);
  if(it!=args_.end())
    {
      std::string av_string=(*it).second;
      std::istringstream is((*it).second);
      is >> av;
    }
  else
    {
      throw std::domain_error("no arg");
    }

  return;
}

void intifada::Configuration_Internal_Parser::find_arg(const arg_type& at,uint8_t& av)const
{
  arg_list_const_iterator_type it = args_.find(at);
  if(it!=args_.end())
    {
      std::string av_string=(*it).second;
      std::istringstream is((*it).second);
      uint16_t av16;
      is >> av16;
      av=av16;
    }
  else
    {
      throw std::domain_error("no arg");
    }

  return;
}
#endif
