#
#  Copyright (C) 2009  Stephane Pion
#  This file is part of Intifada.
#
#   Intifada is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   Intifada is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with Intifada.  If not, see <http://www.gnu.org/licenses/>.
#

dnl
dnl Defining compiler options
dnl
AC_DEFUN([INTIFADA_COMPILER_OPTIONS],[

# debug option
AC_ARG_ENABLE(
	[ndebug],
	AS_HELP_STRING([--enable-ndebug],[add NDEBUG symbol [[default=no]]]),
	[intifada_ndebug_build=$enableval],
	[intifada_ndebug_build=no]
)

# enable frepo (handling templates)
AC_ARG_ENABLE(
	[frepo],
	AS_HELP_STRING([--enable-frepo],[enable template instantiation at link time [[default=no]]]),
	[intifada_frepo=$enableval],
	[intifada_frepo=no]
)

# Turning all warnings in errors
AC_ARG_ENABLE(
	[werror],
	AS_HELP_STRING([--enable-werror],[turn all warnings to error [[default=no]]]),
	[intifada_werror=$enableval],
	[intifada_werror=no]
)
# Turning pedantic compilation
AC_ARG_ENABLE(
	[pedantic],
	AS_HELP_STRING([--enable-pedantic],[turn on pedantic compilation [[default=no]]]),
	[intifada_pedantic=$enableval],
	[intifada_pedantic=no]
)

# turning profiling support
AC_ARG_ENABLE(
	[profile],
	AS_HELP_STRING([--enable-profile],[turn on profiling compilation [[default=no]]]),
	[intifada_profile=$enableval],
	[intifada_profile=no]
)

# enable inline funcs
AC_ARG_ENABLE(
	[inline],
	AS_HELP_STRING([--enable-inline],[enable inline functions (put ixx files in headers) [[default=no]]]),
	[intifada_inline=$enableval],
	[intifada_inline=no]
)


])

AC_DEFUN([INTIFADA_COMPILER_CONFIGURATION],[

# setting compiler caracteristics
test x$intifada_ndebug_build = xyes && CPPFLAGS="$CPPFLAGS -DNDEBUG"
case $CC in
	gcc*)
		CC="$CC -W -Wall"
		test x$intifada_werror = xyes && CC="$CC -Werror"
		test x$intifada_pedantic = xyes && CC="$CC -pedantic"
		test x$intifada_profile = xyes && CFLAGS="$CFLAGS -pg"
	;;
esac
# setting C++ compiler caracteristics

case $CXX in
	g++*)
		# setting warnings
		CXX="$CXX -W -Wall"
		test x$intifada_frepo = xyes && CXX="$CXX -frepo -fno-implicit-templates"
		test x$intifada_werror = xyes && CXX="$CXX -Werror"
		test x$intifada_pedantic = xyes && CXX="$CXX -pedantic"
		test x$intifada_profile = xyes && CXXFLAGS="$CXXFLAGS -pg"
	;;
esac

test x$intifada_profile = xyes &&LDFLAGS="$LDFLAGS -pg"

# Check inline feature
AM_CONDITIONAL([INTIFADA_USE_INLINE],[test x"$intifada_inline" = xyes])

])