<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "my";
include "inc/header.inc.php";

if (!isset($me['user_id']) || $me['user_id'] < 1) {
	header("Location: index.php?" . strip_tags(SID));
	exit;
}

//setup bookmark items
require_once('class/Bookmark.class.php');
$bookmark = new Bookmark($db, null, $me['user_id']);


// manage tracker
if (!empty($_REQUEST['remove_notify'])) {
	$frmdata['bookmark_notify'] = 0;
	
	if (!empty($_REQUEST['blog_id'])) {
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
		$bookmark->item_id = $_REQUEST['blog_id'];
		$bookmark->updateBookmark($frmdata);
	}
	
	if (!empty($_REQUEST['schedule_id'])) {
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
		$bookmark->item_id = $_REQUEST['schedule_id'];
		$bookmark->updateBookmark($frmdata);
	}
	
	if (!empty($_REQUEST['library_id'])) {
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
		$bookmark->item_id = $_REQUEST['library_id'];
		$bookmark->updateBookmark($frmdata);
	}
	
	if (!empty($_REQUEST['subject_id'])) {
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
		$bookmark->item_id = $_REQUEST['subject_id'];
		$bookmark->updateBookmark($frmdata);
	}
	
	if (!empty($_REQUEST['poll_id'])) {
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
		$bookmark->item_id = $_REQUEST['poll_id'];
		$bookmark->updateBookmark($frmdata);
	}
}
elseif (!empty($_REQUEST['add_notify'])) {
	$frmdata['bookmark_notify'] = 1;
	
	if (!empty($_REQUEST['blog_id'])) {
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
		$bookmark->item_id = $_REQUEST['blog_id'];
		$bookmark->updateBookmark($frmdata);
	}
	
	if (!empty($_REQUEST['schedule_id'])) {
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
		$bookmark->item_id = $_REQUEST['schedule_id'];
		$bookmark->updateBookmark($frmdata);
	}
	
	if (!empty($_REQUEST['library_id'])) {
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
		$bookmark->item_id = $_REQUEST['library_id'];
		$bookmark->updateBookmark($frmdata);
	}
	
	if (!empty($_REQUEST['subject_id'])) {
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
		$bookmark->item_id = $_REQUEST['subject_id'];
		$bookmark->updateBookmark($frmdata);
	}
	
	if (!empty($_REQUEST['poll_id'])) {
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
		$bookmark->item_id = $_REQUEST['poll_id'];
		$bookmark->updateBookmark($frmdata);
	}
}

//get watched bookmark ids
$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
if (isset($_POST['watch_blog_delete_id']) && $_POST['watch_blog_delete_id'] > 0) {
	$bookmark->deleteBookmark($_POST['watch_blog_delete_id']);
}
$watched_blog_ids = $bookmark->getBookmarks(1);


$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
if (isset($_POST['watch_schedule_delete_id']) && $_POST['watch_schedule_delete_id'] > 0) {
	$bookmark->deleteBookmark($_POST['watch_schedule_delete_id']);
}
$watched_schedule_ids = $bookmark->getBookmarks(1);


$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
if (isset($_POST['watch_library_delete_name']) && $_POST['watch_library_delete_name'] > 0) {
	$bookmark->deleteBookmark($_POST['watch_library_delete_name']);
}
$watched_library_ids = $bookmark->getBookmarks(1);


$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
if (isset($_POST['watch_subject_delete_id']) && $_POST['watch_subject_delete_id'] > 0) {
	$bookmark->deleteBookmark($_POST['watch_subject_delete_id']);
}
$watched_subject_ids = $bookmark->getBookmarks(1);


$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
if (isset($_POST['watch_poll_delete_id']) && $_POST['watch_poll_delete_id'] > 0) {
	$bookmark->deleteBookmark($_POST['watch_poll_delete_id']);
}
$watched_poll_ids = $bookmark->getBookmarks(1);


//get recommended item ids
$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
if (isset($_POST['rec_blog_delete_id']) && $_POST['rec_blog_delete_id'] > 0) {
	$bookmark->deleteBookmark($_POST['rec_blog_delete_id']);
}
$recommended_blog_ids = $bookmark->getBookmarks();


$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
if (isset($_POST['rec_schedule_delete_id']) && $_POST['rec_schedule_delete_id'] > 0) {
	$bookmark->deleteBookmark($_POST['rec_schedule_delete_id']);
}
$recommended_schedule_ids = $bookmark->getBookmarks();


$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
if (isset($_POST['rec_library_delete_id']) && $_POST['rec_library_delete_id'] > 0) {
	$bookmark->deleteBookmark($_POST['rec_library_delete_id']);
}
$recommended_library_ids = $bookmark->getBookmarks();


$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
if (isset($_POST['rec_subject_delete_id']) && $_POST['rec_subject_delete_id'] > 0) {
	$bookmark->deleteBookmark($_POST['rec_subject_delete_id']);
}
$recommended_subject_ids = $bookmark->getBookmarks();


$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
if (isset($_POST['rec_poll_delete_id']) && $_POST['rec_poll_delete_id'] > 0) {
	$bookmark->deleteBookmark($_POST['rec_poll_delete_id']);
}
$recommended_poll_ids = $bookmark->getBookmarks();

//setup file
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


//setup forum
require_once('class/Forum.class.php');
$forum = new Forum($db, null, $file);
$forum->include_hidden = 1;


//setup blog
require_once('class/Blog.class.php');
$blog = new Blog($db, null, $file);


//library setup
require_once('class/Library.class.php');
$library = new Library($db, null, $file);


//schedule setup
require_once('class/Schedule.class.php');
$schedule = new Schedule($db, null, $date, $file);
$schedule->schedule_config = $c_node['schedule'];


// poll setup
require_once('class/Poll.class.php');
$poll = new Poll($db, null);



//get watched blogs
if (!empty($watched_blog_ids)) {
	foreach ($watched_blog_ids as $key => $i):
		$blog->blog_ids[] = $i['item_id'];
	endforeach;
	$output_watched_blogs = $blog->selBlogs();
	
	// add the bookmark details to the item
	if (!empty($output_watched_blogs)) {
		foreach ($output_watched_blogs as $key => $i):
			foreach ($watched_blog_ids as $keyw => $w):
				if ($i['blog_id'] == $w['item_id']) {
					$output_watched_blogs[$key]['bookmark'] = $w;
					unset($watched_blog_ids[$keyw]);
				}
			endforeach;
		endforeach;
	}
}


//get watched subjects
if (!empty($watched_subject_ids)) {
	foreach ($watched_subject_ids as $key => $i):
		$forum->subject_ids[] = $i['item_id'];
	endforeach;
	$output_watched_subjects = $forum->selSubjects();
	
	// add the bookmark details to the item
	if (!empty($output_watched_subjects)) {
		foreach ($output_watched_subjects as $key => $i):
			foreach ($watched_subject_ids as $keyw => $w):
				if ($i['subject_id'] == $w['item_id']) {
					$output_watched_subjects[$key]['bookmark'] = $w;
					unset($watched_subject_ids[$keyw]);
				}
			endforeach;
		endforeach;
	}
}
//get watched group library items
if (!empty($watched_library_ids)) {
	foreach ($watched_library_ids as $key => $i):
		$library->library_ids[] = $i['item_id'];
	endforeach;
	$output_watched_library_items = $library->selLibraryItems();
	
	// add the bookmark details to the item
	if (!empty($output_watched_library_items)) {
		foreach ($output_watched_library_items as $key => $i):
			foreach ($watched_library_ids as $keyw => $w):
				if ($i['library_id'] == $w['item_id']) {
					$output_watched_library_items[$key]['bookmark'] = $w;
					unset($watched_library_ids[$keyw]);
				}
			endforeach;
		endforeach;
	}
}
//get watched events
if (!empty($watched_schedule_ids)) {
	foreach ($watched_schedule_ids as $key => $i):
		$schedule->schedule_ids[] = $i['item_id'];
	endforeach;
	$output_watched_schedule_items = $schedule->selScheduleItems();
	
	// add the bookmark details to the item
	if (!empty($output_watched_schedule_items)) {
		foreach ($output_watched_schedule_items as $key => $i):
			foreach ($watched_schedule_ids as $keyw => $w):
				if ($i['schedule_id'] == $w['item_id']) {
					$output_watched_schedule_items[$key]['bookmark'] = $w;
					unset($watched_schedule_ids[$keyw]);
				}
			endforeach;
		endforeach;
	}
}
//get watched polls
if (!empty($watched_poll_ids)) {
	foreach ($watched_poll_ids as $key => $i):
		$poll->poll_ids[] = $i['item_id'];
	endforeach;
	$output_watched_polls = $poll->selPolls();
	
	// add the bookmark details to the item
	if (!empty($output_watched_polls)) {
		foreach ($output_watched_polls as $key => $i):
			foreach ($watched_poll_ids as $keyw => $w):
				if ($i['poll_id'] == $w['item_id']) {
					$output_watched_polls[$key]['bookmark'] = $w;
					unset($watched_poll_ids[$keyw]);
				}
			endforeach;
		endforeach;
	}
}


//get recommended user blogs
if (!empty($recommended_blog_ids)) {
	$blog->blog_ids = $recommended_blog_ids;
	$output_recommended_blogs = $blog->selBlogs();
}
//get recommended subjects
if (!empty($recommended_subject_ids)) {
	$forum->subject_ids = $recommended_subject_ids;
	$output_recommended_subjects = $forum->selSubjects();
}
//get recommended group library items
if (!empty($recommended_library_ids)) {
	$library->library_ids = $recommended_library_ids;
	$output_recommended_library_items = $library->selLibraryItems();
}
//get recommended events
if (!empty($recommended_schedule_ids)) {
	$schedule->schedule_ids = $recommended_schedule_ids;
	$output_recommended_schedule_items = $schedule->selScheduleItems();
}
//get recommended polls
if (!empty($recommended_poll_ids)) {
	$poll->poll_ids = $recommended_poll_ids;
	$output_recommended_polls = $poll->selPolls();
}

//move to template
if (isset($output_user)) {
	$body->set('user', $output_user);
}

if (isset($output_watched_subjects)) {
	$body->set('watched_subjects', $output_watched_subjects);
}

if (isset($output_watched_library_items)) {
	$body->set('watched_library', $output_watched_library_items);
}

if (isset($output_watched_blogs)) {
	$body->set('watched_blogs', $output_watched_blogs);
}

if (isset($output_watched_schedule_items)) {
	$body->set('watched_schedule_items', $output_watched_schedule_items);
}

if (isset($output_watched_polls)) {
	$body->set('watched_polls', $output_watched_polls);
}

if (isset($output_recommended_subjects)) {
	$body->set('recommended_subjects', $output_recommended_subjects);
}

if (isset($output_recommended_library_items)) {
	$body->set('recommended_library', $output_recommended_library_items);
}

if (isset($output_recommended_schedule_items)) {
	$body->set('recommended_schedule_items', $output_recommended_schedule_items);
}

if (isset($output_recommended_blogs)) {
	$body->set('recommended_blogs', $output_recommended_blogs);
}

if (isset($output_recommended_polls)) {
	$body->set('recommended_polls', $output_recommended_polls);
}

$body->set('batch_enabled', $c_node['batch']['enabled']);

$template_pageLink = $lang['href_watching'];
include "inc/footer.inc.php";

?>
