<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header_sn.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['network'], $c_acs['arr_acs']['privilege']['allow_directory'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}

//setup file
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
$user->file = $file;


// SETUP TAGS
require_once('class/Tag.class.php');
$tag = new Tag($db, $c_node['rsp']['item_type']['network']);

if (isset($me['user_id'])) {
	$tag->user_id = $me['user_id'];
}

$user->order_by = "p.profile_nic";

if (isset($me['user_id']) && isset($_REQUEST['relation'])) { //display relations
	if ($user_acs->checkPermission($c_acs['arr_acs']['resource']['network'], $c_acs['arr_acs']['privilege']['allow_network'])) { //resourece_id, Priv_id
		
		if (!empty($me['relations'])) {
			foreach($me['relations'] as $key => $i):
				$user->user_ids[] = $i['user_id_relation'];
			endforeach;
		}
		else {
			$user->user_ids[] = 0;
		}
		
		//switch menu to "network"
		$tpl->set('relations', 1);
	}
}

if (!empty($_REQUEST['tag'])) {
	$user->user_id = $me['user_id'];
	$user->item_types = $c_node['rsp']['item_type'];
	$output_users = $user->selUsers($_REQUEST['tag']);
}
else {
	$output_users = $user->selUsers();
}


if (isset($me['user_id'])) {
	$output_relation_of_users = $sn->selRelations($me['user_id'], 1);
}
$first_degree_network_total = 0;
// FIND RELATIONS ---------------------------------------------------------
if (!empty($output_users)) {
	if (isset($me['relations'])) {
		$temp = $me['relations'];
	}
	
	
	$output_blocked = $sn->getBlockedUsers();
	
	foreach($output_users as $key => $i):
		//I AM A RELATION TO USER
		$total_friends = array();
		if (!empty($output_relation_of_users)) {
			foreach($output_relation_of_users as $keyr => $r):
				if ($i['user_id'] == $r['user_id']) {
					$output_users[$key]['am_relation_to_them'] = $r;
					unset ($output_relation_of_users[$keyr]);
					
					// can we show network?
					if (!empty($r['relation_show_network'])) {
						$total_friends = $sn->selRelations($i['user_id']);
					}
				}
			endforeach;
		}
		$output_users[$key]['sn_total'] = count($total_friends);
		
		
		// RELATIONS TO ME
		if (!empty($temp)) {
			foreach($temp as $keyr => $r):
				if ($i['user_id'] == $r['user_id_relation']) {
					$output_users[$key]['relation_to'] = $r;
					unset ($temp[$keyr]);
				}
			endforeach;
		}
		
		
		// BLOCKED BY ME
		if (!empty($output_blocked)) {
			foreach($output_blocked as $keyb => $b):
				if ($i['user_id'] == $b['user_id_blocked']) {
					$output_users[$key]['blocked'] = 1;
					unset ($temp[$keyb]);
				}
			endforeach;
		}
		
		
		$tag->item_id = $i['user_id'];
		$output_users[$key]['tags'] = $tag->selTags();
		
	endforeach;
}


// GET NETWORK STATISTICS -------------------------------------------------
// We select the network statistics. If the network degree 1 total does not
// match the count of the users relations we need to re-compute the statistics.
// If we have batch set we flag batch processing to do that and warn the user 
// that the stats are inaccurate
// Note: None batch installations only display first degree so we update the 
// total and continue.
if (isset($me['user_id'])) {
	$sn->user_id = $me['user_id'];
	$output_sn_statistics['degrees'] = $sn->selSnStatistics();
	
	if ($output_sn_statistics['degrees'][0]['sn_total'] != count($me['relations'])) {
		// recompute 
		$total = count($me['relations']);
		
		if (empty($total)) {
			$total = 0;
		}
			
		if ($c_node['batch']['enabled'] == true) {
			//flag for batch processing 
			$sn->updateSnStatistic(1, $total, 1);
		}
		else {
			//reset degree 1 stats
			$sn->updateSnStatistic(1, $total, null);
		}
		
		$output_sn_statistics['degrees'] = $sn->selSnStatistics();
		
	}
	
	//get pending IM relations
	$output_pending = $sn->getPendingRelations();
	$output_sn_statistics['total_pending'] = count($output_pending);

	// total users
	$output_sn_statistics['total'] = 0;
	if (!empty($output_sn_statistics['degrees'])) {
		foreach ($output_sn_statistics['degrees'] as $key => $i):
			$output_sn_statistics['total'] = $output_sn_statistics['total'] + $i['sn_total'];
		endforeach;
	}
	
	$output_sn_statistics['total'] = $output_sn_statistics['total'] + count($output_sn_statistics['total_pending']);
}

// get total users and total users online
require_once('class/Statistic.class.php');
$statistic = new Statistic($db);
$statistic->user_status = $c_node['user']['status'];
$output_sn_statistics['statistics'] = $statistic->getAllUserStatistics();


// GET TAGS ---------------------------------------------------------------
unset($tag->item_id);
$output_my_tags = $tag->selTags();


//MOVE TO TEMPLATE
if (!empty($output_users)) {
	$body->set('users', $output_users);
}

if (!empty($output_sn_statistics)) {
    $body->set('sn_statistics', $output_sn_statistics);
}

if (!empty($output_pending)) {
	$body->set('pending', $output_pending);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

$template_pageLink =  $lang['txt_network'];

include "inc/footer.inc.php";

?>
