<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
include "inc/header.inc.php";


//ACS check
if (!isset($me['user_id']) || !$user_acs->checkPermission($c_acs['arr_acs']['resource']['schedule'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


//append language setup
require_once($languageArrayPath . 'arr_schedule.lang.php');


// SETUP SCHEDULE ------------------------------------------------------------
require_once('class/Schedule.class.php');
$schedule = new Schedule($db, null, $date, $file);
$schedule->schedule_config = $c_node['schedule'];


if (isset($_REQUEST['schedule_id'])) {
	$schedule->schedule_id = $_REQUEST['schedule_id'];
}

//check schedule types - they are either tasks or events
if (isset($_REQUEST['schedule_type_id'])) {
	//check it is valid
	foreach($c_node['schedule']['type'] as $key => $i):
		if ($i == $_REQUEST['schedule_type_id']) {
		    $output_schedule_item['schedule_type_id'] = $_REQUEST['schedule_type_id'];
			break;
		}
	endforeach;
}

if (!isset($output_schedule_item['schedule_type_id'])) {
	$output_schedule_item['schedule_type_id'] = $c_node['schedule']['type']['event'];
}

$schedule->schedule_type_id = $output_schedule_item['schedule_type_id'];


//SETUP RSP ---------------------------------------------------------
require_once('class/Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['schedule']);
$rsp->user_id = $me['user_id'];


// SETUP WIKI ---------------------------------------------------------------
$wiki_path = "lib_view.php?user_id=" . $me['user_id'] . "&page=";
$wiki_new_path = "lib_edit.php?page=";
$wiki_image_base = "get_file.php?file=";

require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);


// SETUP BOOKMARK ----------------------------------------------------------
require_once('class/Bookmark.class.php');
$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['schedule'], $me['user_id']);
$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];


//RECEIVE POST AND PROCESS ---------------------------------------------------------
if (!empty($frmdata)) {
	$frmdata['schedule_synopsis'] = htmlspecialchars($frmdata['schedule_synopsis']);
	$frmdata['schedule_title'] = htmlspecialchars($frmdata['schedule_title']);

	if (isset($_POST['update_allocations'])) { // allocation
		$schedule->updateScheduleAllocations($schedule->schedule_id, $frmdata['user_ids'], $frmdata['status_ids']);
	
	}
	elseif (isset($frmdata['preview'])) {
		$frmdata['schedule_body'] = stripslashes($frmdata['schedule_body']);
		$frmdata['schedule_synopsis'] = stripslashes($frmdata['schedule_synopsis']);
		$frmdata['schedule_title'] = stripslashes($frmdata['schedule_title']);
		$frmdata['schedule_body_preview'] = $wiki->transform($frmdata['schedule_body'], 'Xhtml');
		
		if (!empty($frmdata['rsp_node'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['node'], 'degree_id' => $frmdata['rsp_degree'], 'rsp_featured' => $frmdata['rsp_public_featured']);
		}
		
		if (!empty($frmdata['rsp_public'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['public'], 'rsp_featured' => $frmdata['rsp_public_featured']);
		}

		$output_schedule_item = $frmdata;

		$display = "edit_overview";
	}
	elseif (isset($frmdata['save_overview']) || isset($frmdata['save_go_overview'])) {
		
		//we format the date unless the schedule item is a task with no start/end datetime
		if (!empty($frmdata['schedule_start_date'])) {
			if (!empty($frmdata['schedule_start_time'])) {
		    	$frmdata['schedule_start_datetime'] = $date->formatFormDateTime($frmdata['schedule_start_date'], $frmdata['schedule_start_time']);
			}
			else {
				$frmdata['schedule_start_datetime'] = $date->formatFormDateTime($frmdata['schedule_start_date']);
			}
		}
		elseif (!empty($frmdata['schedule_no_start_datetime'])) {
			$frmdata['schedule_start_datetime'] = "null";
		}
		else {
			$GLOBALS['igloo_error_log'][] = array(38, null, null);
		}
		
		if (!empty($frmdata['schedule_end_date'])) {
			if (!empty($frmdata['schedule_end_time'])) {
		    	$frmdata['schedule_end_datetime'] = $date->formatFormDateTime($frmdata['schedule_end_date'], $frmdata['schedule_end_time']);
			}
			else {
				$frmdata['schedule_end_datetime'] = $date->formatFormDateTime($frmdata['schedule_end_date']);
			}
		}
		elseif (empty($frmdata['schedule_no_end_datetime'])) {
			$frmdata['schedule_end_datetime'] = "null";
		}
		else {
			$GLOBALS['igloo_error_log'][] = array(39, null, null);
		}
		
		if (!empty($frmdata['schedule_repeat_until'])) {
			$frmdata['schedule_repeat_until'] = $date->formatFormDateTime($frmdata['schedule_repeat_until'], null, 1);
		}
		
		if (empty($frmdata['schedule_title'])) {
		    $GLOBALS['igloo_error_log'][] = array(11, null, null);
		}

		if (!empty($frmdata['schedule_allocation']) && !is_numeric($frmdata['schedule_allocation'])) {
		    $GLOBALS['igloo_error_log'][] = array(40, null, null);
		}

		if (empty($frmdata['schedule_synopsis'])) {
		    $GLOBALS['igloo_error_log'][] = array(30, null, null);
		}

		if (empty($GLOBALS['igloo_error_log'])) {
			
			if (isset($frmdata['schedule_id']) && $frmdata['schedule_id'] > 0) {
		         //we update the event
		 		$schedule->updateScheduleItem($frmdata);
			}
		 	else { //we insert record
		 		$schedule->user_id = $me['user_id'];
		 		$schedule->insertScheduleItem($frmdata);
		 	}

			if (empty($GLOBALS['igloo_error_log'])) {
				//insert into setup rsp
				$temp['language_id'] = $frmdata['language_id'];
				$temp['item_id'] = $schedule->schedule_id;
				//delete all
				$rsp->deleteRspItem($schedule->schedule_id);

				//insert node rsp entry
				if (!empty($frmdata['rsp_node'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
					if (!empty($frmdata['rsp_node_featured'])) {
					    $temp['rsp_featured'] = 1;
					}
					else {
						$temp['rsp_featured'] = "null";
					}
					
					if ($frmdata['rsp_node'] == "all") {
					    $temp['degree_id'] = "null";
					}
					else {
						$temp['degree_id'] = $frmdata['rsp_node'];
					}
					
					if($c_node['rsp']['node']['auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}
					
					$rsp->insertRspItem($temp);
				}
				
				if (!empty($frmdata['rsp_public'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['public'];
					
					if (!empty($frmdata['rsp_public_featured'])) {
					    $temp['rsp_featured'] = 1;
					}
					else {
						$temp['rsp_featured'] = "null";
					}
					
					if($c_node['rsp']['public']['auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}
					
					$rsp->insertRspItem($temp);
				}
				
				// add bookmark tracking
				$bookmark->item_id = $schedule->schedule_id;
				$bookmark->deleteBookmark();
				if (!empty($frmdata['ins_mark'])) {
					$bookmark->insertBookmark(1);
				}
				
				//set alarm
				if (!empty($frmdata['schedule_alarm']) && $frmdata['schedule_alarm'] > 0) {
					$bookmark->item_id = $schedule->schedule_id;
					$bookmark_output = $bookmark->getBookmark();
					//in date we work out the time
					$bookmark->bookmark_alarm_datetime = $date->setAlarmTime($frmdata['schedule_start_datetime'], $frmdata['schedule_alarm']);
					
					if (!empty($bookmark_output)) {
						$bookmark->updateBookmark();
					}
					else {
						$bookmark->insertBookmark();
					}
				}
				
				
				if (isset($frmdata['save_go_overview'])) {
					header("Location: sch_view.php?schedule_id=" . $schedule->schedule_id . "&". strip_tags(SID));
					exit;
				}
				else {
					header("Location: sch_edit.php?schedule_id=" . $schedule->schedule_id . "&". strip_tags(SID));
					exit;
				}
			}
		}
		else { // somehing errored
			$output_schedule_item = $frmdata;
		}

		$display = "edit_overview";


	}
}
elseif (isset($_REQUEST['allocation'])) {
	$schedule->user_id = $me['user_id'];
	
    $output_schedule_item = $schedule->selScheduleItem();
	
	$output_schedule_item_allocation = $schedule->selScheduleAllocations();
	
	$display = "allocation";
}
elseif (isset($_REQUEST['schedule_id']) && $_REQUEST['schedule_id'] > 0) {
	$schedule_id = $_REQUEST['schedule_id'];
	$schedule->schedule_id = $schedule_id;
	$schedule->user_id = $me['user_id']; // gets my allocation
	$output_schedule_item = $schedule->selScheduleItem();

	if ($output_schedule_item['user_id'] == $me['user_id']) { // we are allowed to edit
	    $display = "edit_overview";
	}
	else {
		unset($output_schedule_item, $display);
	}
}
else { // we add a record

	$display = "edit_overview";
}


// SETUP LIBRARY ---------------------------------------------------------
require_once('class/Library.class.php');
$library = new Library($db, null);
$output_wikipages = $library->getPages();
$file->user_id = $me['user_id'];
$output_filenames = $file->getFiles();


//get user default profiles for a allocation
if (!empty($output_schedule_item_allocation)) {
	foreach($output_schedule_item_allocation as $key => $i):
		$user->user_id = $i['user_id'];
		$output_schedule_item_allocation[$key]['profile'] = $user->selProfile();
	endforeach;
}


//format dates
if (isset($output_schedule_item['schedule_start_datetime'])) {
	$output_schedule_item['schedule_start_date'] = substr($output_schedule_item['schedule_start_datetime'], 0,10);
	$output_schedule_item['schedule_end_date'] = substr($output_schedule_item['schedule_end_datetime'], 0,10);
	$output_schedule_item['schedule_start_time'] = substr($output_schedule_item['schedule_start_datetime'], 11,15);
	$output_schedule_item['schedule_end_time'] = substr($output_schedule_item['schedule_end_datetime'], 11,15);
	
	$bookmark->item_id = $output_schedule_item['schedule_id'];
	$bookmark_output = $bookmark->getBookmark();
	
	if (!empty($bookmark_output['bookmark_alarm_datetime'])) {
		$output_schedule_item['schedule_alarm'] = $date->getAlarmMinutes($output_schedule_item['schedule_start_date'], $bookmark_output['bookmark_alarm_datetime']);
	}
	
}
else {
	$output_schedule_item['schedule_start_date'] = date('Y-m-d');
	$output_schedule_item['schedule_end_date'] = date('Y-m-d');
	$output_schedule_item['schedule_start_time'] = date('H:i');
	$output_schedule_item['schedule_end_time'] = date('H:i');
}


if ((isset($_REQUEST['schedule_type_id']) && $_REQUEST['schedule_type_id'] == 2) || (isset($output_schedule_item['schedule_type_id']) && $output_schedule_item['schedule_type_id'] == 2)) { // task
	//we overwrite the standard language file the tasks version
	require_once($languagePath . 'sch_edit_task.lang.php');
}


//setup file ----------------------------------------------------------------
$file->user_id = $me['user_id'];
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif

$output_images = $file->getFiles();


//language and language file manipulation --------------------------------------------
$output_schedule_item['language_id'] = $me['language_id'];


if (isset($output_schedule_item['schedule_id'])) {
	//get bookmark
	$bookmark->item_id = $output_schedule_item['schedule_id'];
	$output_schedule_item['bookmark'] = $bookmark->getBookmark(1);
}


//RSP items
if (!empty($schedule->schedule_id)) {
	$output_schedule_item['rsp'] = $rsp->selRspItem($schedule->schedule_id);
	//print_r($output_schedule_item['rsp']);
}


//move to template ---------------------------------------------------------
if (!empty($blog->blog_id)) {
	$output_blog['rsp'] = $rsp->selRspItem($blog->blog_id);
}

//move vars to template
if (!empty($output_wikipages)) {
	$body->set('wikipages', $output_wikipages);
}

if (!empty($c_node['schedule']['occurrence'])) {
   $body->set('occurrence_ids', $c_node['schedule']['occurrence']);
}

if (!empty($output_schedule_item)) {
   $body->set('schedule', $output_schedule_item);
}

if (isset($display)) {
   $body->set('display', $display);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
}

if (!empty($output_schedule_item_allocation)) {
   $body->set('schedule_allocation', $output_schedule_item_allocation);
}

$body->set('languagePath', $languagePath);

$body->set('rspconfig', $c_node['rsp']);
$body->set('schedule_config', $c_node['schedule']);

include "inc/footer.inc.php";

?>
