<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<form action="msg_view.php<?php if(isset($message_box)) echo "?".$message_box."=";?>" method="post" name="frm" id="id_frm">
<input type="hidden" name="message_id" value="<?php if (isset($message)) {echo $message['message_id'];}?>" />

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_messages'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($message)) {
				?>
				
					<span class="txt_item_title">
						<?php echo $message['message_subject'];?><br />
					</span>
					
					<p>
						<?php echo $message['message_body'];?><br />
					</p>
					
					<?php
					if (isset($message['message_type']) && $message['message_type'] == 1) { //we display the "add friend" button
					?>
					<p>
						<a href="add_relation.php?friend=<?php echo $message['from_user_id'];?>" class="error"><?php echo $lang['txt_message_type1'];?></a><br />
					</p>
					<?php }?>
				<?php }?>
				
				<?php
				if (isset($display)) {
				?>
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<tr>
						<td valign="top">
							<?php
							if (isset($messages)) {
							?>
							<table border="0" cellspacing="0" cellpadding="2" width="100%">
								<tr>
								<td colspan="5">
										<br />
									</td>
									<td align="right" valign="top">
										<input type="checkbox" onClick="checkFormBoxes(this);" /><br />
									</td>
								</tr>
								<?php
								foreach($messages as $key => $i):
								?>
								<tr>
									<td valign="top">
										<?php
										if ($i['message_status'] == $message_status_read) {
											echo "<a href=\"msg_view.php?message_id=" . $i['message_id'] . "\"><img src='" . $templatePath . "img/openned_mail.png' vspace='2' border='0'></a>&nbsp;<br />";
										}
										else if ($i['message_status'] == $message_status_unread) {
											echo "<a href=\"msg_view.php?message_id=" . $i['message_id'] . "\"><img src='" . $templatePath . "img/unopenned_mail.png' vspace='2' border='0'></a>&nbsp;<br />";
										}
										?>
	
									</td>
									<td valign="top">
										<?php
										$user_id = 0;
										if (isset($message_box) && $message_box == 'in_box') {
											$user_id = $i['from_user_id'];
										}
										elseif (isset($message_box) && $message_box == 'out_box') {
											$user_id = $i['to_user_id'];
										}
										else {
											$user_id = $i['owner_user_id'];
										}
										?>
										
										<a href="sn_profile.php?user_id=<?php echo $user_id;?>"><?php echo $i['profile_nic'];?></a><br />
									</td>
									<td valign="top">
										<a href="msg_view.php?message_id=<?php echo $i['message_id'];?>"><?php echo $i['message_subject'];?></a><br />
									</td>
									<td valign="top">
										<?php echo strlen($i['message_body']);?><br />
									</td>
									<td valign="top">
										<?php echo $this->date->formatDate($i['message_create_datetime'], 1);?><br />
									</td>
									<td align="right" valign="top">
										<input type="checkbox" name="message_id[]" value="<?php echo $i['message_id'];?>" /><br />
									</td>
								</tr>
								<?php
								endforeach;
								?>
							</table>
						</td>
					</tr>
					<?php
					} else {
					?>
					<tr>
						<td>
							<?php echo $lang['err_no_messages'];?><br />
						</td>
					</tr>
					<?php }?>
					<tr>
						<td align="right">
							<spanclass="txt_footer">
							<br /><img src="<?php echo $templatePath;?>img/unopenned_mail.png" alt="" />&nbsp;<?php echo $lang['txt_unopened'];?>&nbsp;&nbsp;<img src="<?php echo $templatePath;?>img/openned_mail.png" alt="" />&nbsp;<?php echo $lang['txt_opened'];?>&nbsp;&nbsp;
							</span>
						</td>
					</tr>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_messages'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($author)) {
				?>
					<p>
						<b><?php echo $lang['txt_from'];?></b><br />
					</p>
					
					<?php
					if (isset($author['image'])) {
					?>
					<a href="sn_profile.php?user_id=<?php echo $author['from_user_id'];?>"><img src="get_file.php?file=<?php echo $author['image']['file'];?>" border="0" alt="<?php echo $author['image']['file_title'];?>" /></a><br />
					<?php }?>
					
					<table border="0" cellspacing="0" cellpadding="2" width="100%">
						<tr>
							<td>
								<?php echo $lang['txt_profile_nic'];?><br />
							</td>
							<td>
								<?php echo $author['profile_nic'];?><br />
							</td>
						</tr>
						<tr>
							<td>
								<?php echo $lang['txt_profile_session_status'];?><br />
							</td>
							<td>
								<?php
								if ($author['online_status'] == 1) {
									echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
								}
								else {
										echo $lang['arr_user_online_status'][$author['online_status']] . "<br />";
								}
								?>
							</td>
						</tr>
						<tr>
							<td>
								<?php echo $lang['txt_hometown'];?><br />
							</td>
							<td>
								<?php echo $author['profile_hometown'];?><br />
							</td>
						</tr>
						<tr>
							<td valign="top">
								<?php echo $lang['txt_joined'];?><br />
							</td>
							<td>
								<?php echo $this->date->formatDate($author['profile_create_datetime']);?><br />
							</td>
						</tr>
					</table>
				<?php }?>
				
				<?php
				if (isset($message)) {
				?>
				<p>
				<b>message</b><br />
				</p>
				<table cellpadding="2" cellspacing="0" border="0" width="100%">
					<tr>
						<td>
							<?php echo $lang['hdr_message_sent'];?>:
						</td>
						<td>
							<?php echo $this->date->formatDate($message['message_create_datetime'], 1);?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_message_size'];?><br />
						</td>
						<td>
							<?php echo strlen($message['message_body']);?><br />
						</td>
					</tr>
				</table>
				<?php }?>
				
				<p>
				<b><php? echo $lang['hdr_options']?></b><br />
				</p>
				<table cellpadding="0" cellspacing="0" border="0" width="100%">
					<tr>
						<td>
							<select name="options" class="options_select">
								<?php
								if (isset($message)) {
								?>
								<option value="reply"><?php echo $lang['txt_option_reply'];?></option>
								<option value="mark_read"><?php echo $lang['txt_option_read'];?></option>
								<option value="mark_unread"><?php echo $lang['txt_option_unread'];?></option>
								<option value="move_save"><?php echo $lang['txt_option_move'];?></option>
								<option value="delete"><?php echo $lang['txt_option_delete'];?></option>
								<option> </option>
								<?php }?>
								<option value="goto_in"><?php echo $lang['txt_option_inbox'];?></option>
								<option value="goto_out"><?php echo $lang['txt_option_outbox'];?></option>
								<option value="goto_save"><?php echo $lang['txt_option_savebox'];?></option>
								<option value="compose"><?php echo $lang['txt_option_compose'];?></option>
							</select>
							<input type="image" src="<?php echo $templatePath;?>img/go.png" name="option_action" value="1" class="go" /><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	if (isset($message_statistics)) {
	?>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_messages'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table border="0" cellspacing="1" cellpadding="2" width="100%">
					<tr>
						<td class="bg2">
							<b><?php echo $lang['txt_box'];?></b><br />
						</td>
						<td class="bg3">
							<b><?php echo $lang['txt_messages'];?></b><br />
						</td>
						<td class="bg3">
							<b><?php echo $lang['txt_size'];?></b><br />
						</td>
					</tr>
					<tr>
						<td class="bg2">
							<?php echo $lang['txt_box_in'];?><br />
						</td>
						<td class="bg4">
							<?php echo $message_statistics['in_box_messages'];?>&nbsp;(<?php echo $message_statistics['unread'];?>)<br />
						</td>
						<td class="bg4">
							<?php echo $message_statistics['in_box_size'];?><br />
						</td>
					</tr>
					<tr>
						<td class="bg2">
							<?php echo $lang['txt_box_out'];?><br />
						</td>
						<td class="bg4">
							<?php echo $message_statistics['out_box_messages'];?><br />
						</td>
						<td class="bg4">
							<?php echo $message_statistics['out_box_size'];?><br />
						</td>
					</tr>
					<tr>
						<td class="bg2">
							<?php echo $lang['txt_box_save'];?><br />
						</td>
						<td class="bg4">
							<?php echo $message_statistics['save_box_messages'];?><br />
						</td>
						<td class="bg4">
							<?php echo $message_statistics['save_box_size'];?><br />
						</td>
					</tr>
					<tr>
						<td class="bg2">
							<?php echo $lang['txt_totals'];?><br />
						</td>
						<td class="bg4">
							<b><?php echo $message_statistics['total_messages'];?></b><br />
						</td>
						<td class="bg4">
							<b><?php echo $message_statistics['total_size'];?></b><br />
						</td>
					</tr>
					<?php
					$percentage_used = floor((100/$message_statistics['total_size_allowed']) * $message_statistics['total_size']);
					if ($percentage_used > 100) {
						$percentage_used = 100;
					}
					?>
					<tr>
						<td colspan="3">
							<table border="0" cellspacing="2" cellpadding="0" width="100%">
								<tr>
									<?php if($percentage_used>0) {?>
									<td width="<?php echo $percentage_used;?>%" class="bg1">
										<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
									</td>
									<?php }?>
									<td class="bg2">
										<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
									</td>
								</tr>
							</table>
						</td>
					</tr>
					
					<tr>
						<td align="right" colspan="3">
							<?php echo $percentage_used;?>&#37; <?php echo $lang['txt_used'];?><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>
</form>

<script language="javascript">
<!--

function checkFormBoxes(id) { //task is check or uncheck
	
	var form = document.frm.elements['message_id[]'];
	
	var state = true;
	
	if (id.checked == false) {
		state = false;
		
	}
	
	if (form.length) {
		for (var i=0; i < form.length; i++) {
			form[i].checked = state;
	
		}
	}
	else {
		form.checked = state;
	}
}

//-->
</script>
