#!/usr/bin/perl -w

# IE2G    Converts Microsoft Internet Explorer favorites to Galeon bookmarks
# 
# Version:   0.21  (2002-01-27)
#
# Copyright  (C) 2001-2002 Francesco Poli, <e_frx@inwind.it>
#                          Via Amici 19 50131 Firenze, Italy
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# Note: This script should be usable under any GNU/Linux system with a Perl
#       interpreter. At least, I hope so... ;-)
# 
#

# parse command line arguments
if (@ARGV == 1 and $ARGV[0] eq "--help")
{
    print
    "Usage: ie2g.pl SOURCE DEST VERSION\n",
    "  or:  ie2g.pl --help\n\n",
    "Find all Microsoft Internet Explorer favorites in the subtree with root",
    " in\nSOURCE and convert them into a Galeon bookmark file.\n",
    "This file is named `bookmarks.ie2g' and written in directory DEST.\n\n",
    "(bookmarks.ie2g should be manually copied to ~/.galeon/bookmarks.xml",
    " in\norder to get the converted bookmarks as permanent Galeon",
    " bookmarks)\n(Warning:",
    " file to be overwritten should have been manually backed up!)\n\n",
    "Option VERSION specifies target Galeon version: it must be 0.8.2 or",
    " 0.12\n\n",
    "With the option --help, display this help and exit.\n\n",
    "IE2G version 0.21, Copyright (C) 2001-2002 Francesco Poli\n",
    "IE2G comes with ABSOLUTELY NO WARRANTY.\n",
    "This is free software, and you are welcome to redistribute it\n",
    "under certain conditions; read file `COPYING' for details.\n\n",
    "NOTE: IE2G is designed to convert Internet Explorer favorites that are\n",
    "stored in a filesystem subtree.\n",
    "For those versions of Internet Explorer that save favorites in a single\n",
    "file, you will need a different tool... sorry! :-(\n";
    exit;
}
elsif (@ARGV != 3) 
{
    die "ie2g.pl: wrong number of arguments\n",
    "Try `ie2g.pl --help' for more information.\n";
}
else
{
    ($source, $dest, $version) = @ARGV;
}


SWITCH:
{
    if ($version eq "0.8.2") { $target = 1; $indent = ""  ; last SWITCH; }
    if ($version eq "0.12")  { $target = 2; $indent = "  "; last SWITCH; }
    die "ie2g.pl: third argument must be 0.8.2 or 0.12\n",
    "Try `ie2g.pl --help' for more information.\n";
}

# discard final slash, if present
$dest =~ s/\/$//;

# open output file
open XML, ">$dest/bookmarks.ie2g"  or die
"ie2g.pl: cannot write $dest/bookmarks.ie2g\n";

# start recursion
$id = 0;
&create_category($source, 1, $indent, $target);

# close output file
close XML;

exit;


   ##########################################################################


sub  create_category
{

    # get parameters
    my ($dir, $header, $indent, $target) = @_;

    # change working directory
    chdir $dir;

    # a flag to remember we must finish to write a tag
    my $stmissing = 0;

    if ($header == 1)
    {
        # report activity on stdout
        print "Starting bookmark conversion...\n\n";

        # open root tag
        print XML "<?xml version=\"1.0\"?>\n<bookmarks>\n";

        if ($target == 2)
        {
            print XML "  <folder id=\"0\" name=\"Bookmarks\"",
                      " expanded=\"TRUE\"",
                      " default_bookmarks_root=\"TRUE\"";
            $stmissing = 1;
        }
    }
    else
    {
        # report activity on stdout
        print $indent."opening category \"".$dir."\"\n";

        # filter category or folder name (to enforce XML syntax)
        (my $name = $dir) =~ s/&/%26/g;
        $name =~ s/</%3C/g;
        $name =~ s/>/%3E/g;
        $name =~ s/"/%22/g;

        # open category or folder tag
        if ($target == 1)
        {
            print XML $indent."<category name=\"".$name."\"",
                      " create_toolbar=\"FALSE\" expanded=\"TRUE\"",
                      " notes=\"\"";
            $stmissing = 1;
            $id++;
        }
        else
        {
            print XML $indent."<folder id=\"".++$id."\"",
                      " name=\"".$name."\" expanded=\"TRUE\"";
            $stmissing = 1;
        }
    }

    # list and sort (case-insensitively) current category content 
    my @list = sort {uc($a) cmp uc($b)} `ls -F`;

    # initialize subcategories array
    my @subcategories = ();

    # initialize sites array
    my @sites = ();

    # remember sites and subcategories
    foreach my $element(@list)
    {
        # ls -F appends * to files which have executable flag set, so
        # remove *'s, if present
        $element =~ s/\*$//;

        if ($element =~ /\.url$/)
        {
	    push @sites, $element;
        }
        elsif ($element =~ /\/$/)
        {
            push @subcategories, $element;
        }
    }

    # is our category or folder tag empty (i.e. no sites or subcategories
    # within it) or not?
    my $tag_not_empty = (@sites or @subcategories);

    # if we have neither subcategories or sites then
    # our category or folder tag has to be closed with a slash
    if ($stmissing)
    {
        if ($tag_not_empty)
        { 
            print XML ">\n";
        }
        else
        {
            print XML "/>\n";
        }
    }

    # create sites
    foreach my $site(@sites)
    {
        &create_site($site, "  $indent", $target);
    }

    # create subcategories
    foreach my $subdir(@subcategories)
    {
        # discard newline and slash
        chomp $subdir;
        chop  $subdir;      

        &create_category($subdir, 0, "  $indent", $target);
    }

    if ($header == 1)
    {
        # close root tag if it hasn't been closed already
        if ($target == 2 and $tag_not_empty)
        {
            print XML "  </folder>\n";
        }

        print XML "</bookmarks>\n";

        # report activity on stdout
        print
        "\nBookmark conversion completed!\n$id elements processed!\n\n",
        "Remember to manually backup ~/.galeon/bookmarks.xml\n",
        "and then manually copy bookmarks.ie2g to it.\n\n";
    }
    else
    {
        # close category tag if it hasn't been closed already
        if ($tag_not_empty)
        {
            if ($target == 1)
            {
                print XML $indent."</category>\n";
            }
            else
            {
                print XML $indent."</folder>\n";
            }
        }

        # report activity on stdout
        print $indent."closing category \"".$dir."\"\n";
    }

    # change back working directory
    chdir "..";

}

   ##########################################################################


sub  create_site
{

    # get parameters
    my ($filename, $indent, $target) = @_;

    # discard newline
    chomp $filename;

    # open file to analyse
    open BOOK, "<$filename"  or 
    ( print $indent."WARNING: cannot read \"$filename\"\n" and return );

    # extract the URL
    do { $line = <BOOK>; } until $line =~ /^\[InternetShortcut\]/;
    do { $line = <BOOK>; } until $line =~ /^URL=(.*)$/;
    $url = $1;
    $url =~ s/\r$//;

    # discard ".url"
    $filename =~ s/\.url$//;

    # filter site name (to enforce XML syntax)
    (my $name = $filename) =~ s/&/%26/g;
    $name =~ s/</%3C/g;
    $name =~ s/>/%3E/g;
    $name =~ s/"/%22/g;

    # filter URL (to enforce XML syntax)
    $url =~ s/&/&amp;/g;
    $url =~ s/</&lt;/g;
    $url =~ s/>/&gt;/g;
    $url =~ s/"/&quot;/g;

    # insert site tag
    if ($target == 1)
    {
        print XML $indent."<site name=\"".$name."\"",
                  " url=\"".$url."\" nick=\"\" notes=\"\"/>\n";
        $id++;
    }
    else
    {
        print XML $indent."<site id=\"".++$id."\" name=\"".$name."\"",
                  " url=\"".$url."\"/>\n";
    }

    # report activity on stdout
    print $indent."creating bookmark \"".$filename."\"\n";

    # close the analysed file
    close BOOK;

}


