#!/usr/bin/perl -w

# IE2G    Converts Microsoft Internet Explorer favorites to Galeon bookmarks
# 
# Version:   0.16  (2001-04-23)
#
# Copyright  (C) 2001 Francesco Poli, <e-frx@libero.it>
#                     Via Amici 19 50131 Firenze, Italy
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
# Note: This script should be usable under any GNU/Linux system with a Perl
#       interpreter. At least, I hope so... ;-)
# 
#

# parse command line arguments
if ( (@ARGV == 1) && ($ARGV[0] eq "--help") )
{
    print
    "Usage: ie2g.pl SOURCE DEST\n",
    "  or:  ie2g.pl --help\n\n",
    "Find all Microsoft Internet Explorer favorites in the subtree with root",
    " in\nSOURCE and convert them into a Galeon bookmark file.\n",
    "This file is named `bookmarks.ie2g' and written in directory DEST.\n\n",
    "(bookmarks.ie2g should be manually copied to ~/.galeon/bookmarks.xml",
    " or\nto ~/.galeon/temp_bookmarks.xml in order to get the converted",
    " bookmarks\nas permanent or temporary Galeon bookmarks)\n(Warning:",
    " file to be overwritten should have been manually backed up!)\n\n",
    "With the option --help, display this help and exit.\n\n",
    "IE2G version 0.16, Copyright (C) 2001 Francesco Poli\n",
    "IE2G comes with ABSOLUTELY NO WARRANTY.\n",
    "This is free software, and you are welcome to redistribute it\n",
    "under certain conditions; read file `COPYING' for details.\n\n",
    "NOTE: IE2G is designed to convert Internet Explorer favorites that are\n",
    "stored in a filesystem subtree.\n",
    "For those versions of Internet Explorer that save favorites in a single\n",
    "file, you will need a different tool... sorry! :-(\n";
    exit;
}
elsif (@ARGV != 2) 
{
    die "ie2g.pl: wrong number of arguments\n",
    "Try `ie2g.pl --help' for more information.\n";
}
else
{
    ($source, $dest) = @ARGV;
}


# change working directory
chdir $dest;

# discard final slash, if present
if ( $dest =~ /\/$/ ) { chop $dest; }

# open output file
open XML, ">bookmarks.ie2g"  or die
"ie2g.pl: cannot write $dest/bookmarks.ie2g\n";

# start recursion
&create_category($source, 1, "");

# close output file
close XML;

exit;


   ##########################################################################


sub  create_category
{

    # get parameters
    my ($dir, $header, $indent) = @_;

    # change working directory
    chdir $dir;

    if ($header == 1)
    {
        # open root tag
        print XML "<?xml version=\"1.0\"?>\n<bookmarks>\n";

        # report activity on stdout
        print "Starting bookmark conversion...\n\n";
    }
    else
    {
        # open category tag
        print XML $indent."<category name=\"".$dir."\"",
                  " create_toolbar=\"FALSE\" expanded=\"TRUE\"",
                  " notes=\"\">\n";

        # report activity on stdout
        print $indent."opening category \"".$dir."\"\n";
    }

    # list and sort (case-insensitively) current category content 
    my @list = sort {uc($a) cmp uc($b)} `ls -F`;

    # initialize subcategories array
    my @subcategories = ();

    # create sites and remember subcategories
    foreach my $element(@list)
    {
        if ($element =~ /\.url$/)
        {
            &create_site($element, "  $indent");
        }
        elsif ($element =~ /\/$/)
        {
            push @subcategories, $element;
        }
    }

    # create subcategories
    foreach my $subdir(@subcategories)
    {
        # discard newline and slash
        chomp $subdir;
        chop  $subdir;      

        &create_category($subdir, 0, "  $indent");
    }

    if ($header == 1)
    {
        # close root tag
        print XML "</bookmarks>\n";

        # report activity on stdout
        print
        "\nBookmark conversion completed!\n\nRemember",
        " to manually backup ~/.galeon/bookmarks.xml\nor",
        " ~/.galeon/temp_bookmarks.xml and then manually\n",
        "copy bookmarks.ie2g to it.\n\n";
    }
    else
    {
        # close category tag
        print XML $indent."</category>\n";

        # report activity on stdout
        print $indent."closing category \"".$dir."\"\n";
    }

    # change back working directory
    chdir "..";

}


   ##########################################################################


sub  create_site
{

    # get parameters
    my ($filename, $indent) = @_;

    # discard newline
    chomp $filename;

    # open file to analyse
    open BOOK, "<$filename"  or 
    ( print $indent."WARNING: cannot read \"$filename\"\n" and return );

    # extract the URL
    do { $line = <BOOK>; } until $line =~ /^\[InternetShortcut\]/;
    do { $line = <BOOK>; } until $line =~ /^URL=(.*)$/;
    $url = $1;
    if ($url =~ /\r$/) { chop $url; }

    # discard ".url"
    chop $filename; chop $filename; chop $filename; chop $filename;

    # insert site tag
    print XML $indent."<site name=\"".$filename."\"",
              " url=\"".$url."\" nick=\"\" notes=\"\"/>\n";

    # report activity on stdout
    print $indent."creating bookmark \"".$filename."\"\n";

    # close the analysed file
    close BOOK;

}


