# $Id: icel-inf.tcl 2005-01-16 14:25:05 mferra $
# Copyright (C) 2004 - Marco Ferra <mferra@sdf.lonestar.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


proc pub:icel:inf {nc hs hn ch tx} {
  global icel

  set pl [split $tx]

  if {[icel:hdb]} {
    puthelp "notice $nc :can't open database"
    return 0
  }

  set fx "You"

  if {[string length $tx]} {
    set nc [lindex $pl 0]
    set fx "Him"
  }

  set nc [mysql_escape $nc]

  if {$icel(cdb)} {
    set ax [llength [mysql_query "SELECT * FROM $icel(tbl)"]]
    set bx [llength [mysql_query "SELECT * FROM $icel(tbl) GROUP BY unit"]]
    set cx [llength [mysql_query "SELECT * FROM $icel(tbl) WHERE nick = '$nc'"]]
    set dx [llength [mysql_query "SELECT * FROM $icel(tbl) WHERE nick = '$nc' GROUP BY unit"]]
  } else {
    set ax [llength [mysql_query "SELECT * FROM $icel(tbl) WHERE chan = '$ch'"]]
    set bx [llength [mysql_query "SELECT * FROM from $icel(tbl) WHERE chan = '$ch' GROUP BY unit"]]
    set cx [llength [mysql_query "SELECT * FROM from $icel(tbl) WHERE nick = '$nc' && chan = '$ch'"]]
    set dx [llength [mysql_query "SELECT * FROM from $icel(tbl) WHERE nick = '$nc' && chan = '$ch' GROUP BY unit"]]
  }

  mysql_close

  set ex [format "%0.2f" [expr (($cx + 0.00) * 100) / $ax]]

  puthelp "privmsg $ch :DB totals \[Keys/Defs\]: $bx/$ax.  $fx: \[Keys/Defs\]: $dx/$cx.  Contributed: $ex%"

  putlog "icel: $nc on $ch did !i $tx (done)"
}
