##
## Input file for automake
##
## Copyright (C) 2008, 2009 Francesco Salvestrini
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License along
## with this program; if not, write to the Free Software Foundation, Inc.,
## 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
##

include archs/x86/Makefile.inc
include archs/ppc32/Makefile.inc
include archs/common/Makefile.inc
include archs/boot/Makefile.inc

EXTRA_DIST +=					\
	archs/Makefile.inc.in

arch_SRCS           =
arch_multiboot_SRCS =

if SUPPORT_ARCH_X86
arch_SRCS           += $(arch_x86_SRCS)
arch_multiboot_SRCS += $(arch_x86_multiboot_SRCS)
endif

if SUPPORT_ARCH_PPC32
arch_SRCS           += $(arch_ppc32_SRCS)
arch_multiboot_SRCS += $(arch_ppc32_multiboot_SRCS)
endif

##
## NOTE:
##   Multiboot compliance force us to have the multiboot header first so we
##   must split the architecture level sources into arch_SRCS and
##   arch_multiboot_SRCS.
##
##   Another trick to enforce the multiboot compliance is available inside the
##   kernel linker script
##
## XXX FIXME:
##   Both solutions are quite awful, we should find a better solution ASAP
##
arch_SRCS +=					\
	$(arch_common_SRCS)			\
	$(arch_boot_SRCS)			\
	archs/arch.h				\
	archs/linker.h
