##
## Input file for automake
##
## Copyright (C) 2008, 2009 Francesco Salvestrini
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License along
## with this program; if not, write to the Free Software Foundation, Inc.,
## 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
##

include config/Makefile.cfg

EXTRA_DIST +=					\
	config/Makefile.inc.in		\
	config/autoconfig-tweaks.h		\
	config/config.h

BUILT_SOURCES +=				\
	config/userconfig.h

#
# NOTE:
#     The following rule must not depend on Makefile (it should be run one
#     time only ...
$(USERCONFIG):
	cp $(top_srcdir)/src/archs/$(architecture)/bsp/configs/default.usr $(USERCONFIG) || exit 1

config/rules.all: Makefile $(CFG_FILES) $(RULES2SYMS)
	$(RULES2SYMS) $(RULES2SYMS_FLAGS) -o config/rules.all -- $(CFG_FILES) || { rm -f config/rules.all ; exit 1 ; }
CLEANFILES += config/rules.all

config/rules.out: Makefile config/rules.all $(USERCONFIG) $(MERGESYMS)
	$(MERGESYMS) $(MERGESYMS_FLAGS) -i config/rules.all -j $(USERCONFIG) -o config/rules.out || { rm -f config/rules.out ; exit 1 ; }
CLEANFILES += config/rules.out

config/userconfig.h: Makefile config/rules.out $(SH2H)
	$(SH2H) $(SH2H_FLAGS) -g USERCONFIG_H -p CONFIG_ -i config/rules.out -o config/userconfig.h || { rm -f config/userconfig.h ; exit 1 ; }
CLEANFILES += config/userconfig.h

# This file has been generated by configure (or modified by the user so
# distclean target must remove it ...
DISTCLEANFILES +=				\
	$(USERCONFIG)
