;; Netscape elements and attributes
;; An html-helper-mode/html-writer-mode module

;; Joe Hildebrand <hildjj@fuentez.com> - 23 May 1995
;; version: 1.2

;; Modified for HTML 4.01 compliance by Shawn K. Quinn
;; Modifications coypright (C) 2001,2004,2005 by Shawn K. Quinn

;; $Id: tables.el,v 1.2 2005/05/23 17:06:24 skquinn Exp $

;; This code is distributed under the same terms as html-writer-mode
;; itself. html-writer-mode for Emacs is maintained by Shawn K. Quinn
;; <skquinn@speakeasy.net>, based on html-helper-mode originally written
;; by Nelson Minar <nelson@santafe.edu>, and is available from
;; <URL:http://savannah.nongnu.org/projects/html-writer-mode/>

;; The extensions to HTML supported by this module used to be documented
;; at
;; <URL:http://home.netscape.com/assist/net_sites/html_extensions.html>
;; but appear to have vanished sometime post-AOL-buyout.

;; This code must be called *after* html-writer-mode loads.  It can be
;; run nicely from the html-writer-load-hook.

;; skquinn changes:

;; * HTML 4.01 compliance, new elements TH, THEAD, TFOOT, TBODY,
;; CAPTION, COL, COLGROUP.

;; * s/html-helper/html-writer/

(html-writer-add-type-to-alist
 '(table . (table-html-map "\C-c\C-e" table-html-menu
			   "Insert Table Elements")))
(html-writer-install-type 'table)

(html-writer-add-tag
 '(table "t" "<table summary=\"Purpose of Table\">" "table no border"
	 ("<table summary=\"" (r "Table summary: ") "\">\n" (r "Table: ") "\n</table>")))
(html-writer-add-tag
 '(table "b" "<table border=\"1\">" "table with border"
	 ("<table border=\"1\" summary=\"" (r "Table summary: ") "\">" (r "Table: ") "\n</table>")))
(html-writer-add-tag
 '(table "d" "<td>" "table data" ("<td>" (r "Table Data: ") "</td>")))
(html-writer-add-tag
 '(table "e" "<th>" "table header cell" ("<th>" (r "Table Header: ") "</th>")))
(html-writer-add-tag
 '(table "r" "<tr>" "table row" ("<tr>" (r "Table Row: ") "\n\n\n</tr>\n")))
(html-writer-add-tag
 '(table "h" "<thead" "table heading" ("<thead>" (r "Table Heading: ") "</thead>")))
(html-writer-add-tag
 '(table "f" "<tfoot" "table footer" ("<tfoot>" (r "Table Footer: ") "</tfoot>")))
(html-writer-add-tag
 '(table "y" "<tbody" "table body" ("<tbody>" (r "Table Body: ") "</tbody>")))
(html-writer-add-tag
 '(table "c" "<caption" "table caption"
	 ("<caption>" (r "Table Caption: ") "</caption>\n")))
(html-writer-add-tag
 '(table "l" "<col>" "column"
	 ("<col span=\"" (r "Span: ") "\">\n")))
(html-writer-add-tag
 '(table "g" "<colgroup" "column group"
	 ("<colgroup span=\"" (r "Span: ") "\">\n")))

(html-writer-rebuild-menu)

(defun hwm-table nil)

(provide 'hwm-table)
(provide 'hhm-table)                    ; backward compatibility
